#!/bin/sh
# $Id: t-mapaddr-1.sh,v 1.2 2005/06/06 16:40:33 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test lookup of addresses including replacements (%n)
# Uses t-mapaddrr-0, t-mm
# ------------------------------------------------------------
#
test -s stop && exit 1
#

BDBIN="bdb3"
BDB="bdb3.db"
OUT=out3
CMP=cmp3
OK=ok3
DIFF=diff3
ERRS=0

# data for map
cat > ${BDBIN} <<EOF
Tag:user2++@other.domain	rhs-Tag:user2-plus-%0-other.domain
Tag:user2+*@other.domain	rhs-Tag:user2-star-%0-other.domain
Tag:other.domain	rhs-Tag:user-%0-detail-%1-other.domain
alias+detail	rhs-alias-detail
alias++	rhs-alias-plus
alias+*	rhs-alias-star
alias	rhs-alias
virt+detail@vhost.domain	rhs-virt-detail-vhost.domain
virt++@vhost.domain	rhs-virt-plus-%0-vhost.domain
virt+*@vhost.domain	rhs-virt-star-%0-vhost.domain
virt@vhost.domain	rhs-virt/%0-vhost.domain
nodetail@vhost.domain	rhs-nodetail%0%1-vhost.domain
vdom+detail@.domain	rhs-vdom-detail-.domain
vdom++@.domain	rhs-vdom-plus-%1.domain
vdom+*@.domain	rhs-vdom-star-%1.domain
vdom@.domain	rhs-vdom-%0.domain
vlocal+detail@	rhs-vlocal-detail-@
vlocal++@	rhs-vlocal-plus-@
vlocal+*@	rhs-vlocal-star-@
vlocal@	rhs-virt-@
EOF

# create map
rm -f ${BDB}
./t-mm -t'	' -F ${BDB} < ${BDBIN}
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

for P in ./t-mapaddrr-0 # ./t-mapaddr-0
do

# test full lookup with replacements
${P} -r >${OUT} 2>&1 <<EOF
tag:user2:isdetail:other.domain
tag:user2::other.domain
tag:isuser:thisdetail:other.domain
tag:isuser::other.domain
EOF

cat >${OK} <<EOF
ret=1, rhs='rhs-Tag:user2-plus-isdetail-other.domain'
ret=1, rhs='rhs-Tag:user2-star--other.domain'
ret=2, rhs='rhs-Tag:user-isuser-detail-thisdetail-other.domain'
ret=2, rhs='rhs-Tag:user-isuser-detail--other.domain'
EOF

grep -v ' tests completed ' ${OUT} > ${CMP}

diff ${CMP} ${OK} > ${DIFF}
if test $? != 0
then
  echo errors:
  cat ${DIFF}
  ERRS=`expr ${ERRS} + 1 `
fi


done

exit ${ERRS}
