/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: aq_rcpt_err_state.c,v 1.4 2005/05/31 21:03:59 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/actdb-int.h"
#include "sm/da.h"

/*
**  AQ_RCPT_ERR_STATE -- Translate delivery error state into text
**
**	Parameters:
**		aq_rcpt -- AQ recipient
**		perrmsg -- (pointer to) error message (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
aq_rcpt_err_state(aq_rcpt_P aq_rcpt, sm_str_P errmsg)
{
	sm_ret_T ret;
	char *err_msg;

	SM_REQUIRE(errmsg != NULL);
	SM_IS_AQ_RCPT(aq_rcpt);
	ret = SM_SUCCESS;
	err_msg = NULL;
	switch (da_err_cmd(aq_rcpt->aqr_err_st))
	{
	  case DA_TA_ERR_MAIL:
		err_msg = "during MAIL";
		break;
	  case DA_TA_ERR_RCPT:
		err_msg = "during RCPT";
		break;
	  case DA_TA_ERR_DATA:
		err_msg = "during DATA";
		break;
	  case DA_TA_ERR_CDB:
		err_msg = "during opening of body";
		break;
	  case DA_TA_ERR_BODY:
		err_msg = "during transmission of body";
		break;
	  case DA_TA_ERR_DOT:
		err_msg = "during final dot";
		break;
	  case DA_TA_ERR_L_RCPT:
		err_msg = "during LMTP RCPT";
		break;
	  case DA_TA_ERR_RSET:
		err_msg = "during RSET";
		break;
	  case DA_TA_ERR_SIZE:
		err_msg = "during SIZE check";
		break;
	  case DA_SE_ERR_OPEN:
		err_msg = "during session open";
		break;
	  case DA_SE_ERR_GRET:
		err_msg = "during session greeting";
		break;
	  case DA_SE_ERR_EHLO:
		err_msg = "during EHLO";
		break;
	  case DA_SE_ERR_HELO:
		err_msg = "during HELO";
		break;
	  case DA_SE_ERR_STLS:
		err_msg = "during STARTTLS";
		break;
	  case DA_SE_ERR_TTMYSLEF:
#if 0
		err_msg = "server greeting contains my hostname";
#else /* 0 */
		err_msg = "config error: mail loops back to me";
#endif /* 0 */
		break;
	  case DA_AR_ERR:
		switch (aq_rcpt->aqr_status)
		{
		  case SMTP_AR_NOTF:
			err_msg = "error from address resolver "
				"record not found";
			break;
		  case SMTP_AR_TEMP:
			err_msg = "error from address resolver "
				"temporary error";
			break;
		  case SMTP_AR_PERM:
			err_msg = "error from address resolver "
				"permanent error";
			break;
		  case SMTP_AR_TMO:
			err_msg = "error from address resolver "
				"timeout during query";
			break;
		  case SMTP_AR_MXEMPTY:
			err_msg = "error from address resolver "
				"MX points back to me";
			break;
		  case SMTP_AR_ALIAS:
			err_msg = "error from address resolver "
				"alias expansion failed";
			break;
		  case SMTP_AR_AL_REC:
			err_msg = "error from address resolver "
				"alias nesting too deep";
			break;
		  case SMTP_AR_LOOP:
			err_msg = "error from address resolver "
				"CNAME recursion";
			break;
		  default:
			err_msg = "unknown error from address resolver";
#if 0
			sm_snprintf(err_txt, sizeof(err_txt),
				"unknown error %d from address resolver"
				, aq_rcpt->aqr_status);
			err_msg = err_txt;
#endif /* 0 */
			break;
		}
		break;

	  case DA_AQ_TMO_ERR:
		err_msg = "item too long in active queue";
		break;
	  case DA_DQ_TMO_ERR:
		err_msg = "maximum time in queue exceeded";
		break;
	  case DA_TERMINATED:
		err_msg = "delivery agent module did not respond before timeout";
		break;
	}

	if (err_msg != NULL)
		ret = sm_str_scat(errmsg, err_msg);
	return ret;
}
