/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: pmilter_getstatus.c,v 1.1 2005/06/20 20:27:03 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "pmilter.h"
#include "sm/pmfdef.h"
#include "sm/pmfapi.h"

#if SM_USE_PMILTER

/*
**  SM_PMFI_GETSTATUS -- Get status for current SMTP command (only RCPT)
**
**	Parameters:
**		pmse_ctx -- pmilter/SMTP server session context
**		pstatus -- (pointer to) status (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmfi_getstatus(pmse_ctx_P pmse_ctx, sfsistat_T *pstatus)
{
	SM_IS_PMSE_CTX(pmse_ctx);
	if (pstatus == NULL)
		return EINVAL;
	*pstatus = (sfsistat_T) pmse_ctx->pmse_cmd_status;
	return SM_SUCCESS;
}
#endif /* SM_USE_PMILTER */
