/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: args2argv.c,v 1.8 2005/05/10 21:57:27 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/str.h"
#include "util.h"

/*
**  ARGS2ARGV -- split a str into a list of strings, NULL terminated
**
**	Parameters:
**		str -- str consisting of { argname \0 argvalue \0 } *
**		pnelem -- (pointer to) number of elements (output)
**		pargv -- (pointer to) array of strings (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
args2argv(sm_str_P str, uint *pnelem, char ***pargv)
{
	size_t i, len;
	int elem, nelem;
	bool eq;
	char **s;

	SM_REQUIRE(pargv != NULL);
	*pargv = NULL;
	if (pnelem != NULL)
		*pnelem = 0;
	if (str == NULL)
		return SM_SUCCESS;
	nelem = 0;
	eq = true;
	len = sm_str_getlen(str);
	for (i = 0; i < len; i++)
	{
		if (sm_str_rd_elem(str, i) == '\0')
		{
			if (eq)
				sm_str_wr_elem(str, i, (uchar) '=');
			else
				++nelem;
			eq = !eq;
		}
	}
	if (nelem == 0)
		return SM_SUCCESS;
	if (eq)
		return sm_error_perm(SM_EM_PMILTER, EINVAL);

	/* loop counts delimiters */
	++nelem;
	s = (char **)sm_zalloc(nelem * (sizeof *s));
	if (s == NULL)
		return sm_error_temp(SM_EM_PMILTER, ENOMEM);
	s[0] = (char *) sm_str_data(str);
	for (i = 0, elem = 0; i < len && elem < nelem; i++)
	{
		if (sm_str_rd_elem(str, i) == '\0')
		{
			++elem;
			if (i + 1 >= len)
				s[elem] = NULL;
			else
				s[elem] = (char *) sm_str_data(str) + i + 1;
		}
	}

	/* overwrite last entry (already done above, just paranoia) */
	s[elem] = NULL;
	*pargv = s;
	if (pnelem != NULL)
		*pnelem = nelem;
	return SM_SUCCESS;
}
