/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-greyrm.c,v 1.1 2005/08/04 06:12:28 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/types.h"
#include "sm/net.h"
#include "sm/greyctl.h"
#include "sm/greycnf.h"
#include "sm/io.h"
#include "sm/test.h"
#include "greyctl.h"

static int Verbose = 0;

static void
greyrm(int argc, char **argv)
{
	sm_ret_T ret;
	int i;
	ipv4_T addr;
	greyctx_P greyctx;

	ret = sm_greyctl_crt(&greyctx);
	SM_TEST(ret == SM_SUCCESS);
	if (ret != SM_SUCCESS)
		return;
	ret = sm_greyctl_open(greyctx, NULL);
	SM_TEST(ret == SM_SUCCESS);
	if (ret != SM_SUCCESS)
		return;

	for (i = 0; i < argc; i++)
	{
		ret = sm_inet_a2ipv4(argv[i], NULL, &addr);
		if (sm_is_success(ret))
		{
			ret = sm_grey_rm(greyctx->greyc_grey_db, addr);
			if (Verbose)
				sm_io_fprintf(smioerr, "ip=%A, rm=%r\n",
					addr, ret);
		}
	}
	ret = sm_greyctl_free(greyctx);
	SM_TEST(ret == SM_SUCCESS);
}

int
main(int argc, char *argv[])
{
	int c;

	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbose;
			break;
		  default:
			return(1);
		}
	}
	argc -= optind;
	argv += optind;
	greyrm(argc, argv);
	return 0;
}
