/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strscatv.c,v 1.6 2005/05/31 21:03:57 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/varargs.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_SCATV -- Append multiple strings to dst
**	This version stops when the copying fails, creating a partial copy.
**
**	Parameters:
**		dst -- str destination
**		n -- number of source strings
**		... -- strings to append
**		(should we use NULL as end marker instead?)
**
**	Returns:
**		usual sm_ret_T
*/

sm_ret_T
sm_str_scatv(sm_str_P dst, int n, ...)
{
	sm_ret_T res;
	char *s;
	va_list ap;

	SM_IS_BUF(dst);
	va_start(ap, n);

	/* loop through all source strings */
	while (n-- > 0)
	{
		s = va_arg(ap, char *);
		res = sm_str_scat(dst, s);
		if (sm_is_err(res))
		{
			va_end(ap);
			return res;
		}
	}
	va_end(ap);
	return SM_SUCCESS;
}
