/*
 *  This code is based on src/lib/libc/net/inet_addr.c from FreeBSD 4.8
 */

/*	$KAME: inet_addr.c,v 1.5 2001/08/20 02:32:40 itojun Exp $	*/

/*
 * ++Copyright++ 1983, 1990, 1993
 * -
 * Copyright (c) 1983, 1990, 1993
 *    The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * -
 * Portions Copyright (c) 1993 by Digital Equipment Corporation.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies, and that
 * the name of Digital Equipment Corporation not be used in advertising or
 * publicity pertaining to distribution of the document or software without
 * specific, written prior permission.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * -
 * --Copyright--
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: sm_inet_a2ipv4.c,v 1.8 2005/03/21 22:56:24 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/ctype.h"
#include "sm/net.h"


#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)inet_addr.c	8.1 (Berkeley) 6/17/93";
static char rcsid[] = "$FreeBSD: src/lib/libc/net/inet_addr.c,v 1.12.2.2 2002/04/28 05:40:24 suz Exp $";
#endif /* LIBC_SCCS and not lint */

#if 0
///*
//**  ASCII internet address interpretation routine.
//**  The value returned is in network order.
//*/
//
//ipv4_T		/* should be struct in_addr :( */
//sm_inet_addr(const char *cp)
//{
//	struct in_addr val;
//
//	if (inet_aton(cp, &val))
//		return val.s_addr;
//	return (INADDR_NONE);
//}
#endif /* 0 */

/*
**  SM_INET_A2IPV4 -- (check and) convert ASCII version of IP address to binary
**
**	Parameters:
**		cp -- begin of ASCII representation
**		end -- (pointer to) end of ASCII representation (output)
**		ipv4 -- IPv4 address (output)
**
**	Returns:
**		usual sm_error code; ERANGE, EINVAL, ...
*/

sm_ret_T
sm_inet_a2ipv4(const char *cp, char **end, ipv4_T *ipv4)
{
	ulong parts[4], ul;
	ipv4_T val;
	char *c, *endptr;
	int n;
	bool gotend, brackets;

	c = (char *)cp;
	n = 0;
	if (end != NULL)
		*end = NULL;

	/*
	**  Run through the string, grabbing numbers until the end of the
	**  string, or some error
	*/

	gotend = false;
	brackets = (*c == '[');
	if (brackets)
		++c;
	ul = 0;
	while (!gotend)
	{
		errno = 0;
		ul = strtoul(c, &endptr, 0);

		if (errno == ERANGE)	/* Fail completely if it overflowed. */
			return sm_error_perm(SM_EM_IP, errno);
#if SIZEOF_LONG > 4
		if (ul > UINT32_MAX)
			return sm_error_perm(SM_EM_IP, ERANGE);
#endif

		/*
		**  If the whole string is invalid, endptr will equal c.. this
		**  way we can make sure someone hasn't gone '.12' or something
		**  which would get past the next check.
		*/

		if (endptr == c)
			return sm_error_perm(SM_EM_IP, EINVAL);
		parts[n] = ul;
		c = endptr;

		/* Check the next character past the previous number's end */
		switch (*c)
		{
		  case '.':
			/* Make sure we only do 3 dots .. */
			if (n >= 3)	/* Whoops. Quit. */
				return sm_error_perm(SM_EM_IP, EINVAL);
			n++;
			c++;
			break;

		  case '\0':
			if (brackets)
				return sm_error_perm(SM_EM_IP, EINVAL);
			gotend = true;
			break;

		  case ']':
			if (brackets)
			{
				gotend = true;
				c++;
				break;
			}
			/* FALLTHROUGH */
		  default:
			if (ISSPACE(*c) && !brackets)
			{
				gotend = true;
				break;
			}
			else
			{
				return sm_error_perm(SM_EM_IP, EINVAL);
				/* Invalid character, so fail */
			}
		}

	}
	val = ul;

	/* Concoct the address according to the number of parts specified */
	switch (n)
	{
	  case 0:		/* a -- 32 bits */
		/*
		**  Nothing is necessary here.  Overflow checking was already
		**  done in strtoul() (and above).
		*/

		break;
	  case 1:		/* a.b -- 8.24 bits */
		if (val > 0xffffff || parts[0] > 0xff)
			return sm_error_perm(SM_EM_IP, EINVAL);
		val |= parts[0] << 24;
		break;

	  case 2:		/* a.b.c -- 8.8.16 bits */
		if (val > 0xffff || parts[0] > 0xff || parts[1] > 0xff)
			return sm_error_perm(SM_EM_IP, EINVAL);
		val |= (parts[0] << 24) | (parts[1] << 16);
		break;

	  case 3:		/* a.b.c.d -- 8.8.8.8 bits */
		if (val > 0xff || parts[0] > 0xff || parts[1] > 0xff ||
		    parts[2] > 0xff)
			return sm_error_perm(SM_EM_IP, EINVAL);
		val |= (parts[0] << 24) | (parts[1] << 16) | (parts[2] << 8);
		break;
	}
	if (ipv4 != NULL)
		*ipv4 = htonl(val);
	if (end != NULL)
		*end = c;
	return SM_SUCCESS;
}
