/*
 * Copyright (c) 2002, 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbput2int.c,v 1.9 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/rcb.h"
#include "sm/str-int.h"
#include "sm/str2rcb.h"
#include "sm/reccom.h"

/*
**  SM_RCB_PUT2UINT32 -- Append two ints to the end of a sm_rcb_P.
**
**	Parameters:
**		rcb -- sm_rcb_P object to append onto.
**		n1 -- value to append.
**		n2 -- value to append.
**
**	Returns:
**		usual sm_error code; ENOMEM, SM_E_OVFLW_SC, SM_E_OVFLW_NS
**
**	Last code review: 2005-03-23 02:18:03
**	Last code change:
*/

sm_ret_T
sm_rcb_put2uint32(sm_rcb_P rcb, uint32_t n1, uint32_t n2)
{
	uint nsize;

	SM_IS_RCB(rcb);

	nsize = rcb->sm_rcb_len + sizeof(uint32_t) * 2;

	/* overflow? */
	if (nsize <= rcb->sm_rcb_len)
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_SC);

	/* do we really want to do this? */
	if (rcb->sm_rcb_rw >= 0 && (int)(2 * sizeof(uint32_t)) > rcb->sm_rcb_rw)
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);
	if (nsize > rcb->sm_rcb_size)
		SM_STR_INCREASE_R(rcb, nsize);
	sm_uint32_2buf(n1, rcb->sm_rcb_base + rcb->sm_rcb_len);
	rcb->sm_rcb_len += sizeof(uint32_t);
	sm_uint32_2buf(n2, rcb->sm_rcb_base + rcb->sm_rcb_len);
	rcb->sm_rcb_len += sizeof(uint32_t);
	if (rcb->sm_rcb_rw >= 0)
		rcb->sm_rcb_rw -= sizeof(uint32_t) * 2;
	return SM_SUCCESS;
}
