/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbgetncstr.c,v 1.13 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "sm/limits.h"
#include "sm/cstr.h"
#include "sm/rcb.h"

/*
**  SM_RCB_GETNCSTR -- Create new cstr object from rcb (n bytes).
**
**	Parameters:
**		rcb -- sm_rcb_P object to read from.
**		pcstr -- (pointer to) pcstr, will be created (output)
**		n -- number of bytes to copy (aligned to 4 bytes).
**
**	Returns:
**		usual sm_error code; ENOMEM, SM_E_OVFLW_NS
**
**	Side Effects: none on error
**
**	Last code review: 2005-03-18 23:44:02
**	Last code change:
*/

sm_ret_T
sm_rcb_getncstr(sm_rcb_P rcb, sm_cstr_P *pcstr, uint n)
{
	uint la;

	SM_IS_RCB(rcb);
#if SM_RCB_CHECK
	SM_REQUIRE(rcb->sm_rcb_state == SM_RCB_DEC);
#endif
	SM_REQUIRE(pcstr != NULL);
	la = SM_ALIGN4(n);
	SM_REQUIRE(la >= n);
	SM_REQUIRE((int)la > 0);
	SM_REQUIRE(rcb->sm_rcb_rw + (int) la >= rcb->sm_rcb_rw);
	if (rcb->sm_rcb_rw + la > rcb->sm_rcb_len)
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);
	*pcstr = sm_cstr_scpyn(rcb->sm_rcb_base + rcb->sm_rcb_rw, n);
	if (*pcstr == NULL)
		return sm_error_temp(SM_EM_RECCOM, ENOMEM);
	rcb->sm_rcb_rw += la;
	return SM_SUCCESS;
}
