/*
 * Copyright (c) 2002, 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbgetn.c,v 1.11 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/str-int.h"
#include "sm/rcb.h"

/*
**  SM_RCB_GETN -- Read data from rcb into get (n bytes).
**
**	Parameters:
**		rcb -- sm_rcb_P object to read from.
**		get -- data to fill.
**		n -- number of bytes to copy (aligned to 4 bytes).
**
**	Returns:
**		usual sm_error code; SM_E_OVFLW_NS
**
**	Last code review: 2005-03-29 05:30:42
**	Last code change:
*/

sm_ret_T
sm_rcb_getn(sm_rcb_P rcb, uchar *get, uint n)
{
	uint la;

	SM_IS_RCB(rcb);
#if SM_RCB_CHECK
	SM_REQUIRE(rcb->sm_rcb_state == SM_RCB_DEC);
#endif
#if PARANOID
	SM_REQUIRE(get != NULL);
	SM_REQUIRE(rcb->sm_rcb_base != NULL);
#endif
	SM_ASSERT(get != NULL);
	la = SM_ALIGN4(n);
	if (rcb->sm_rcb_rw + la > rcb->sm_rcb_len)
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);
	sm_memcpy((void *) get, rcb->sm_rcb_base + rcb->sm_rcb_rw, n);
	rcb->sm_rcb_rw += la;
	return SM_SUCCESS;
}
