/*
 * Copyright (c) 2000-2002 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fwalk.c,v 1.3 2002/05/09 16:35:30 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "io-int.h"
#include "io-glue.h"

/*
**  SM_FWALK -- apply a function to all found-open file pointers
**
**	Parameters:
**		function -- a function vector to be applied
**
**	Returns:
**		The (binary) OR'd result of each function call
**		XXX this need to be fixed? try something like err_max() ?
*/

int
sm_fwalk(sm_f_walk_F function)
{
	sm_file_T *fp;
	int n, ret;
	struct sm_glue *g;

	ret = 0;
	for (g = &smglue; g != NULL; g = g->gl_next)
	{
		for (fp = g->gl_iobs, n = g->gl_niobs; --n >= 0; fp++)
		{
			if (f_flags(*fp) != 0)
			{
				ret |= (*function)(fp);
			}
		}
	}
	return ret;
}
