/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: cpu_count.c,v 1.1 2004/10/05 21:14:41 ca Exp $")

#include "sm/error.h"
#include "sm/util.h"

/*
**  SM_CPU_COUNT -- Try to determine the number of (active?) CPUs
**
**	Parameters:
**		none.
**
**	Returns:
**		>0: number of CPUs
**		<0: usual sm_error code
*/


sm_ret_T
sm_cpu_count(void)
{
	int n;

#if defined (_SC_NPROCESSORS_ONLN)
	n = (int) sysconf(_SC_NPROCESSORS_ONLN);
#elif defined (_SC_NPROC_ONLN)
	n = (int) sysconf(_SC_NPROC_ONLN);
#elif defined (HPUX)
#include <sys/mpctl.h>
	n = mpctl(MPC_GETNUMSPUS, 0, 0);
#else
	n = sm_err_perm(ENOSYS);
#endif
	return n;
}
