/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: ibdb.h,v 1.3 2005/08/15 06:14:17 ca Exp $
 */

#ifndef IDB_H
#define IDB_H 1

#include "sm/generic.h"
#include "sm/str.h"
#include "sm/ibdb.h"

/*
**  Create full path from directory, basename, and sequence number.
**  Here things like directory hashing or subdirectories can be
**  introduced, as well as changes like decimal -> hexadecimal for
**  more hashing.
**  Note: instead of storing "dir" we may want to store "flags"
**  as they are used below in IBDB_DIR(dir, flags) to generate the
**  directory. In this case we can switch from directory based
**  distinction to some other scheme, e.g., prefix.
*/

#define IBDB_WR_DIR	"ibdb/ibdb"	/* normal write directory */
#define IBDB_REC_DIR	"ibdb/ibdbr"	/* recovery directory */
#define IBDB_CL_DIR	"ibdb/ibdbc"	/* cleanup directory */

/* should format be 'X' instead of 'd'?? */
#define crt_ibdb_path(path, dir, name, seq)	\
	sm_strprintf((path), "%s/%s%0" SM_XSTR(UINT32_LEN) "d",	\
		(dir), (name), (seq))

#define IBDB_DIR(dir, flags)	do				\
	{							\
	if (IBDB_IS_OPEN_FLAG(flags, IBDB_OFL_WRITE))		\
		dir = IBDB_WR_DIR;				\
	else if (IBDB_IS_OPEN_FLAG(flags, IBDB_OFL_RCVR))	\
		dir = IBDB_REC_DIR;				\
	else if (IBDB_IS_OPEN_FLAG(flags, IBDB_OFL_CLEAN))	\
		dir = IBDB_CL_DIR;				\
	else							\
		dir = ".";	/* Really?? abort instead? */	\
	} while (0)

#endif /* IDB_H */
