/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: edbct.c,v 1.4 2005/04/11 16:28:26 ca Exp $")
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "sm/assert.h"
#include "sm/str.h"
#include "sm/edbc.h"
#include "edbc.h"
#include "sm/qmgrdbg.h"

/*
**  EDBCT_RM -- remove an entire edbc tree node from envelope database cache
**
**	Parameters:
**		edbc_ctx -- edbc context
**		edbc_tnode -- edbc tree node
**
**	Returns:
**		usual sm_error code; SM_E_NOTFOUND
**
**	Locking: must be performed by caller.
*/

sm_ret_T
edbct_rm(edbc_ctx_P edbc_ctx, edbc_tnode_P edbc_tnode)
{
	edbc_node_P edbc_node;

	SM_REQUIRE(edbc_ctx != NULL);
	SM_REQUIRE(edbc_tnode != NULL);

	while (!ECNL_EMPTY(&(edbc_tnode->ectn_hd)))
	{
		edbc_node = ECNL_FIRST(&(edbc_tnode->ectn_hd));
		ECNL_REMOVE(&(edbc_tnode->ectn_hd), edbc_node);
		sm_free_size(edbc_node, sizeof(*edbc_node));
		--edbc_ctx->edbc_entries;
	}
	if (RB_REMOVE(edbc_tree_S, &(edbc_ctx->edbc_root), edbc_tnode)
	    != NULL)
	{
		sm_free_size(edbc_tnode, sizeof(*edbc_tnode));
		return SM_SUCCESS;
	}
	return sm_error_temp(SM_EM_Q_EDBC, SM_E_NOTFOUND);
}

/*
**  EDBCT_LAST -- return last edbd tree node from envelope database cache
**
**	Parameters:
**		edbc_ctx -- edbc context
**
**	Returns:
**		edbc_node
**
**	Locking: must be performed by caller.
*/

edbc_tnode_P
edbct_last(edbc_ctx_P edbc_ctx)
{
	edbc_tnode_P edbc_tnode;

	SM_REQUIRE(edbc_ctx != NULL);
	edbc_tnode = RB_MAX(edbc_tree_S, &(edbc_ctx->edbc_root));
	return edbc_tnode;
}
