/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: edbreqll.c,v 1.9 2005/02/22 22:28:05 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/edb.h"
#include "edb-int.h"

/*
**  EDB_REQL_INIT -- init edb request list
**
**	Parameters:
**		edb_ctx -- EDB context
**		edb_req_hd -- head of request list for (DEF)EDB
**		locktype -- kind of locking (edb_ctx)
**
**	Returns:
**		SM_SUCCESS
**
**	Locking: no locking.
**
**	Note: this can't be defined as macro because currently the code
**		expects a return value. "work around": use EDBREQL_INIT()
**		directly.
*/

sm_ret_T
edb_reql_init(edb_ctx_P edb_ctx, edb_req_hd_P edb_req_hd, thr_lock_T locktype)
{
	SM_REQUIRE(edb_req_hd != NULL);
	EDBREQL_INIT(edb_req_hd);
	return SM_SUCCESS;
}
