/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sm-conf-token.h,v 1.6 2005/06/16 00:39:03 ca Exp $
 */

#ifndef sm_conf_TOKEN_H
#define sm_conf_TOKEN_H 1

#if SM_LIBCONF_ALONE
#include <stdlib.h>
#include "sm-conf.h"
#else
#include "sm/sm-conf.h"
#endif


/* SM-CONF-TOKEN.H -- internal tokenizer declarations. */

enum sm_conf_token_type_E
{
	SM_CONF_TOKEN_ERROR	= -2,
	SM_CONF_TOKEN_EOF	= -1,
	SM_CONF_TOKEN_NONE	= 0,
	SM_CONF_TOKEN_STRING	= '"',
	SM_CONF_TOKEN_ATOM	= 'a',
	SM_CONF_TOKEN_SEMI	= ';',
	SM_CONF_TOKEN_OBRACE	= '{',
	SM_CONF_TOKEN_CBRACE	= '}',
	SM_CONF_TOKEN_COMMA	= ',',
	SM_CONF_TOKEN_EQUAL	= '='
};

#define SM_CONF_TOKEN_MAGIC SM_MAGIC('C', 'T', 'O', 'K')
#define SM_IS_CONF_TOKEN(sm_conf_token)	\
	SM_REQUIRE((sm_conf_token) != NULL &&	\
		(sm_conf_token)->sm_magic == SM_CONF_TOKEN_MAGIC)

typedef struct sm_conf_TOKEN_S
{
	sm_magic_T			 sm_magic;
	enum sm_conf_token_type_E	 sct_type;
	size_t				 sct_line;

	char const			*sct_text;
	size_t				 sct_text_n;

	enum SM_CONF_ERROR_E		 sct_error;

} sm_conf_token_T;

enum sm_conf_token_type_E sm_conf_token(
	sm_conf_T	*_smc,
	sm_conf_token_T *_tok,
	unsigned int	_flags);

/*
**  SM_CONF_TOKEN_FLAG_IDENTIFIER -- When reading atoms, stop at
**	the first white space or non-identifier character.  Don't
**	combine multiple adjacent atoms, specials, and strings
**	into one atom.
*/

#define SM_CONF_TOKEN_FLAG_IDENTIFIER	0x01


enum sm_conf_token_type_E sm_conf_token_lookahead(sm_conf_T const *_smc);
char const * sm_conf_token_string(
		sm_conf_T	*_smc,
		sm_conf_token_T *_tok,
		char		*_buf,
		size_t		_bufsize);

enum SM_CONF_ERROR_E sm_conf_token_backslash(
	sm_conf_T		*_smc,
	char			**_s_ptr,
	char const		**_r_ptr,
	char const		*_e);

/* A good value for a buffer passed into sm_conf_token_string. */
#define SM_CONF_TOKEN_BUFFER_SIZE	200

int sm_conf_token_match(
	sm_conf_T		*_smc,
	char const		*_user,
	size_t			_user_n,
	char const		*_data,
	size_t			_data_n);

#endif	/* sm_conf_TOKEN_H */
