/*
 * Copyright (c) 2000-2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: types.h,v 1.8 2005/06/16 00:09:35 ca Exp $
 */

/*
**  This header file defines standard integral types.
**  - It includes <sys/types.h>, and fixes portability problems that
**    exist on older Unix platforms.
**  - It defines longlong_T and ulonglong_T, which are portable locutions
**    for 'long long' and 'unsigned long long'.
*/

#ifndef SM_TYPES_H
#define SM_TYPES_H 1

#include "sm/generic.h"

#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

/* timeout interval, may need to be long, must be signed */
typedef int	sm_intvl_T;

/*
**  Define longlong_T and ulonglong_T, which are portable locutions
**  for 'long long' and 'unsigned long long' from the C 1999 standard.
*/

#if (SIZEOF_LONG_LONG > 0)
typedef long long		longlong_T;
typedef unsigned long long	ulonglong_T;
#else /* (SIZEOF_LONG_LONG > 0) */
# if (SIZEOF_QUAD_T > 0)
typedef quad_t		longlong_T;
typedef u_quad_t	ulonglong_T;
# else
typedef long		longlong_T;
typedef unsigned long	ulonglong_T;
# endif
#endif /* (SIZEOF_LONG_LONG > 0) */

#endif /* ! SM_TYPES_H */
