/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: smarcnf.h,v 1.26 2005/08/15 17:02:48 ca Exp $
 */

#ifndef SMARCNF_H
#define SMARCNF_H	1

#include "sm/generic.h"
#include "sm/net.h"
#include "sm/dnstsk.h"	/* for SM_DNS_MAX_TSKS */
#include "sm/io.h"
#include "sm/sm-conf.h"
#include "sm/logcnfdef.h"
#include "sm/mapcnf.h"
#include "sm/mcpcnfs.h"
#include "sm/greycnf.h"

#ifndef SM_MAX_DNSBL
#define SM_MAX_DNSBL	8	/* max number of dns blocklists */
#endif

/* DNS BL data */
typedef struct smar_cnfdnsbl_S	smar_cnfdnsbl_T, *smar_cnfdnsbl_P;
struct smar_cnfdnsbl_S
{
	char		*scdb_name;	/* domain name of DNS blocklist */
	char		*scdb_tag;	/* tag for lookup in access map */
	/* include trailing ':'? */

#if 0
	/*
	**  Do we need these?
	**  Reject message is listed in access map, tempfail can
	**  be simulated by returning "400" as result and
	**  looking it up in access map.
	*/

	char		*scdb_rejmsg;	/* reject message */
	char		*scdb_tmpmsg;	/* tempfail message */
	uint32_t	 scbd_flags;	/* flags */
#endif /* 0 */
};

/* SMAR configuration context */
typedef struct smar_cnf_S		smar_cnf_T, *smar_cnf_P;
struct smar_cnf_S
{
#if 0
	sm_magic_T	 sm_magic;
#endif /* 0 */
	sm_conf_T	*smar_cnf_smc;		/* parsed configuration */
	char		*smar_cnf_conffile;	/* name of configuration file */
	char		*smar_cnf_sock;		/* SMAR socket */
	char		*smar_cnf_hostname;

	/* put local user map (lum) related data into substructure? */
	char		*smar_cnf_lum_name;
	uint		 smar_cnf_lum_fl;	/* flags */

	char		*smar_cnf_alias_fn;
	char		*smar_cnf_alias_path;
	uint		 smar_cnf_alias_fl;	/* aliases flags */
	char		*smar_cnf_mt_fn;
	char		*smar_cnf_mt_name;
	char		*smar_cnf_mt_path;
	char		*smar_cnf_access_fn;
	char		*smar_cnf_access_path;

	/* evthr parameters */
	uint		 smar_cnf_minthr;
	uint		 smar_cnf_maxthr;
	uint		 smar_cnf_maxfd;

	uint		 smar_cnf_loglevel;
	sm_logspec_T	 smar_cnf_log;
	uint		 smar_cnf_dns_timeout;
	char		*smar_cnf_nameservers[SM_DNS_MAX_TSKS];
	uint		 smar_cnf_dns_flags;
	smar_cnfdnsbl_T	 smar_cnf_dnsbl[SM_MAX_DNSBL];
	uint		 smar_cnf_dnsbl_n;
	map_decl_T	 smar_cnf_mapdecl;

	uchar		 smar_cnf_addr_delim;

	greycnf_T	 smar_cnf_grey;

	MCP_STRUCTS(smar_cnf_T, smar_cnf)
};

void smar_prt_cnf(smar_cnf_P _smar_cnf, sm_file_T *_fp, bool _all);

#endif /* SMARCNF_H */
