/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sm-conf-time.h,v 1.5 2005/06/20 19:03:16 ca Exp $
 */

#ifndef SM_CONF_TIME_H
#define SM_CONF_TIME_H 1

#include "sm/generic.h"
#include "sm/assert.h"
#include "sm/magic.h"

#if SM_CONF_TIME_DEF
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN
sm_conf_definition_T const sm_conf_time_suffixes[]
#if SM_CONF_TIME_DEF
=
{
	{ SM_CONF_DEF_MAGIC, "s", sm_conf_type_u32_suffix, 1,
	60, NULL, 0, NULL, NULL, NULL, "" },
	{ SM_CONF_DEF_MAGIC, "m", sm_conf_type_u32_suffix, 60,
	60, NULL, 0, NULL, NULL, NULL, "" },
	{ SM_CONF_DEF_MAGIC, "h", sm_conf_type_u32_suffix, 60 * 60,
	24, NULL, 0, NULL, NULL, NULL, "" },
	{ SM_CONF_DEF_MAGIC, "d", sm_conf_type_u32_suffix, 60 * 60 * 24,
	7, NULL, 0, NULL, NULL, NULL, "" },
	{ SM_CONF_DEF_MAGIC, "w", sm_conf_type_u32_suffix, 60 * 60 * 24 * 7,
	0, NULL, 0, NULL, NULL, NULL, "" },
#if 0
	{ SM_CONF_DEF_MAGIC, "y", sm_conf_type_u32_suffix, 60 * 60 * 24 * 365,
	0, NULL, 0, NULL, NULL, NULL, "" },
#endif

	/*
	**  Hack to be able to read initialization data that uses
	**  the macros defined in sm/units.h
	*/

	{ SM_CONF_DEF_MAGIC,
	"*60",	sm_conf_type_u32_suffix, 60,
	0, NULL, 0, NULL, NULL, NULL, "" },
	{ SM_CONF_DEF_MAGIC,
	"*60*60",	sm_conf_type_u32_suffix, 60 * 60,
	0, NULL, 0, NULL, NULL, NULL, "" },
	{ SM_CONF_DEF_MAGIC,
	"*60*60*24",	sm_conf_type_u32_suffix, 60 * 60 * 24,
	0, NULL, 0, NULL, NULL, NULL, "" },
	{ SM_CONF_DEF_MAGIC,
	"*60*60*24*7",	sm_conf_type_u32_suffix, 60 * 60 * 24 * 7,
	0, NULL, 0, NULL, NULL, NULL, "" },

	/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL },
}
#endif /* SM_CONF_TIME_DEF */
;

#undef EXTERN

#endif /* SM_CONF_TIME_H */
