/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: sccnfdef.h,v 1.27 2005/10/25 23:33:40 ca Exp $
 */

#ifndef SM_SCCNFDEF_H
#define SM_SCCNFDEF_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/time.h"
#include "sm/qmgrcnf.h"
#include "sm/mcpcnfs.h"
#include "sm/mta.h"
#include "sm/smtpdef.h"
#include "sm/sm-conf-time.h"

#define LMTPSOCK	"lmtpsock"

#if SM_SCCNFDEF
#define EXTERN
#else
#define EXTERN extern
#endif

#if SM_USE_TLS
EXTERN
sm_conf_definition_T
sc_tls_defs[]
#if SM_SCCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "cert_file",	sm_conf_type_string,
	offsetof(sc_cnf_T, sc_cnf_cert),	0,
	SM_MTA_CERT,
	0,	NULL,	NULL,	NULL,
	"File with certificate in PEM format" },
{ SM_CONF_DEF_MAGIC, "key_file",	sm_conf_type_string,
	offsetof(sc_cnf_T, sc_cnf_key),	0,
	SM_MTA_KEY,
	0,	NULL,	NULL,	NULL,
	"File with private key for certificate in PEM format" },
{ SM_CONF_DEF_MAGIC, "DSA_cert_file",	sm_conf_type_string,
	offsetof(sc_cnf_T, sc_cnf_dsa_cert),	0,
	NULL,	0,	NULL,	NULL,	NULL,
	"File with DSA certificate in PEM format" },
{ SM_CONF_DEF_MAGIC, "DSA_key_file",	sm_conf_type_string,
	offsetof(sc_cnf_T, sc_cnf_dsa_key),	0,
	NULL,	0,	NULL,	NULL,	NULL,
	"File with private key for DSA certificate in PEM format" },
{ SM_CONF_DEF_MAGIC, "CAcert_file",	sm_conf_type_string,
	offsetof(sc_cnf_T, sc_cnf_cacert),	0,
	SM_MTA_CACERT,
	0,	NULL,	NULL,	NULL,
	"File with CA certificate in PEM format" },
{ SM_CONF_DEF_MAGIC, "CAcert_directory",	sm_conf_type_string,
	offsetof(sc_cnf_T, sc_cnf_certpath),	0,
	SM_MTA_CERTP,
	0,	NULL,	NULL,	NULL,
	"Directory with (symbolic links for) CA certificates in PEM format" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SCCNFDEF */
;
#endif /* SM_USE_TLS */


EXTERN
sm_conf_definition_T
sc_defs[]
#if SM_SCCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "remote_port",			sm_conf_type_u32,
	offsetof(sc_cnf_T, sc_cnf_port),	sizeof(int),
	SM_XSTR(SMTPC_PORT),	0,	NULL,	NULL,	NULL,
	"port to connect to on server"	},
{ SM_CONF_DEF_MAGIC, "LMTP_socket",		sm_conf_type_string,
	offsetof(sc_cnf_T, sc_cnf_lmtpsock ),	0,
	LMTPSOCK,	0,	NULL,	NULL,	NULL,
	""	},

{ SM_CONF_DEF_MAGIC, "processes",		sm_conf_type_u32,
	offsetof(sc_cnf_T, sc_cnf_vp_count),	sizeof(int),
	"1",	0,	NULL,	NULL,	NULL,
	"number of processes to start [currently not implemented]"	},

{ SM_CONF_DEF_MAGIC, "max_threads",		sm_conf_type_u32,
	offsetof(sc_cnf_T, sc_cnf_max_threads),	sizeof(uint),
	SM_XSTR(MAX_THREADS_DEFAULT),	0,	NULL,	NULL,	NULL,
	"maximum number of threads"	},

{ SM_CONF_DEF_MAGIC, "max_wait_threads",		sm_conf_type_u32,
	offsetof(sc_cnf_T, sc_cnf_max_wait_threads),	sizeof(uint),
	SM_XSTR(MAX_WAIT_THREADS_DEFAULT),	0,	NULL,	NULL,	NULL,
	"maximum number of waiting threads"	},

{ SM_CONF_DEF_MAGIC, "min_wait_threads",		sm_conf_type_u32,
	offsetof(sc_cnf_T, sc_cnf_min_wait_threads),	sizeof(uint),
	SM_XSTR(MIN_WAIT_THREADS_DEFAULT),	0,	NULL,	NULL,	NULL,
	"minimum number of waiting threads"	},

{ SM_CONF_DEF_MAGIC, "flags",		sm_conf_type_u32,
	offsetof(sc_cnf_T, sc_cnf_confflags),	sizeof(uint32_t),
	"0",	0,	NULL,	NULL,	NULL,
	""	},

{ SM_CONF_DEF_MAGIC, "log_level",		sm_conf_type_u32,
	offsetof(sc_cnf_T, sc_cnf_loglevel),	sizeof(uint),
	SM_XSTR(SM_LOG_LEVEL),	0,	NULL,	NULL,	NULL,
	""	},
{ SM_CONF_DEF_MAGIC, "log", sm_conf_type_section,
	offsetof(sc_cnf_T, sc_cnf_log),		0,
	NULL, SM_CONF_FLAG_KEEP_DEFAULT, sm_log_spec_defs,
	NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "debug_level",		sm_conf_type_u32,
	offsetof(sc_cnf_T, sc_cnf_debug),	sizeof(int),
	"0",	0,	NULL,	NULL,	NULL,
	NULL	},

{ SM_CONF_DEF_MAGIC, "io_timeout",		sm_conf_type_u32,
	offsetof(sc_cnf_T, sc_cnf_timeout),	sizeof(sm_intvl_T),
	SM_XSTR(SC_IO_TIMEOUT),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"timeout for SMTP I/O operations"	},

{ SM_CONF_DEF_MAGIC, "wait_for_server",		sm_conf_type_u32,
	offsetof(sc_cnf_T, sc_cnf_wait4srv),	sizeof(uint),
	"1",			0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"maximum amount of time to wait for a server to become available" },

{ SM_CONF_DEF_MAGIC, "id",			sm_conf_type_u32,
	offsetof(sc_cnf_T, sc_cnf_id),		sizeof(uint),
	SM_XSTR(SMTPC_ID),	SM_CONF_FLAG_KEEP_DEFAULT,
	NULL,	NULL,	NULL,
	"unique id"	},

{ SM_CONF_DEF_MAGIC, "connect_only_to",		sm_conf_type_ipv4,
	offsetof(sc_cnf_T, sc_cnf_sink),	sizeof(ipv4_T),
	"0",			0,	0,
	NULL,	NULL,
	"connect only to this IPv4 address [testing]" },

#if SM_USE_TLS
{ SM_CONF_DEF_MAGIC, "tls", sm_conf_type_section,
	0, sizeof(sc_cnf_T), NULL,
	SM_CONF_FLAG_KEEP_DEFAULT|SM_CONF_FLAG_MULTIPLE,
	sc_tls_defs,
	NULL, NULL, NULL },
#endif /* SM_USE_TLS */

	MCP_DEFS(sc_cnf_T, sc_cnf)

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SCCNFDEF */
;

EXTERN
sm_conf_definition_T
sc_global_defs[]
#if SM_SCCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "SMTPC_socket",	sm_conf_type_string,
	offsetof(sc_cnf_T, sc_cnf_smtpcsock),	0,	smsmtpcsock,
	0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "CDB_base_directory",	sm_conf_type_string,
	offsetof(sc_cnf_T, sc_cnf_cdb_base),	0,	"",
	0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC, "hostname",		sm_conf_type_string,
	offsetof(sc_cnf_T, sc_cnf_hostname),	0,	NULL,
	0, NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "smtpc", sm_conf_type_section,
	0, sizeof(sc_cnf_T), NULL,
	SM_CONF_FLAG_KEEP_DEFAULT|SM_CONF_FLAG_MULTIPLE|SM_CONF_FLAG_PARSE_ONLY,
	sc_defs,
	NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SCCNFDEF */
;

#undef EXTERN

#endif /* SM_SCCNFDEF_H */
