/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: sccnf.h,v 1.15 2005/10/25 23:33:40 ca Exp $
 */

#ifndef SCCNF_H
#define SCCNF_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/time.h"
#include "sm/net.h"
#include "sm/io.h"
#include "sm/sm-conf.h"
#include "sm/logcnfdef.h"
#include "sm/mcpcnfs.h"

/* SMTPC configuration context */
typedef struct sc_cnf_S		sc_cnf_T, *sc_cnf_P;
struct sc_cnf_S
{
#if 0
	sm_magic_T	 sm_magic;
#endif /* 0 */
	sm_conf_T	*sc_cnf_smc;		/* parsed configuration */
	char		*sc_cnf_conffile;	/* name of configuration file */
	char		*sc_cnf_section;	/* name of section to use */
	char		*sc_cnf_smtpcsock;	/* SMTP Client/QMGR socket */
	char		*sc_cnf_cdb_base;	/* Base name for CDB */
	char		*sc_cnf_lmtpsock;
	char		*sc_cnf_hostname;
	uint		 sc_cnf_id;
	int		 sc_cnf_port;
	ipv4_T		 sc_cnf_sink;	/* if != 0: connect only to this sink */
	int		 sc_cnf_vp_count; /* Number of server processes (VPs) */

	/*
	**  Thread throttling parameters (all numbers are per listening socket).
	**  Zero values mean use default.
	*/

	/* Max number of "spare" threads */
	uint		 sc_cnf_max_wait_threads;

	/* Min number of "spare" threads */
	uint		 sc_cnf_min_wait_threads;

	/* Max number threads */
	uint		 sc_cnf_max_threads;

	uint32_t	 sc_cnf_confflags;	/* SMTPC configuration flags */
	sm_intvl_T	 sc_cnf_timeout;	/* timeout for I/O */
	uint		 sc_cnf_wait4srv; /* how long to wait for QMGR? */
	uint		 sc_cnf_loglevel;
	sm_logspec_T	 sc_cnf_log;
	int		 sc_cnf_debug;	/* debug level */
#if 0
	char		*sc_cnf_logdir;
#endif /* 0 */
#if SM_USE_TLS
	char		*sc_cnf_cert;
	char		*sc_cnf_key;
	char		*sc_cnf_dsa_cert;
	char		*sc_cnf_dsa_key;
	char		*sc_cnf_certpath;
	char		*sc_cnf_cacert;

	char		*sc_cnf_cert_abs;
	char		*sc_cnf_key_abs;
	char		*sc_cnf_dsa_cert_abs;
	char		*sc_cnf_dsa_key_abs;
	char		*sc_cnf_certpath_abs;
	char		*sc_cnf_cacert_abs;
#endif /* SM_USE_TLS */

	MCP_STRUCTS(sc_cnf_T, sc_cnf)
};

void sc_prt_cnf(sc_cnf_P _sc_cnf, sm_file_T *_fp, bool _all);

#endif /* SCCNF_H */
