/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: qmgrdef.h,v 1.17 2005/09/20 19:47:19 ca Exp $
 */

#ifndef SM_QMGRDEF_H
#define SM_QMGRDEF_H 1

#include "sm/generic.h"
#include "sm/units.h"

/*
**  Various defaults for QMGR (esp. configuration).
**  Note: if these values are changed than test programs that use -F
**  need to be changed too!
*/

#define QCNF_FL_NONE		0x00000000
#define QCNF_FL_SE_REUSE	0x00000001	/* try to reuse sessions */
#define QCNF_FL_NO_SCHED	0x00000002	/* no scheduler (testing!) */
/* 4: free */
#define QCNF_FL_B_HDR		0x00000008	/* bounce: headers only */
#define QCNF_FL_B_DSN_MIME	0x00000010	/* bounce in MIME format */

/* bounce: first body, then headers */
#define QCNF_FL_B_BODY_HDR	0x00000020

/* config values (tunable) */
#define IQDB_CSIZE	1023	/* incoming edb size (rsc) */
#define IQDB_HTSIZE	2111	/* incoming edb size (bht) */
#define IBDB_SIZE	65536	/* backup edb size */
#define OCC_CSIZE	2111	/* outgoing connection cache size (rsc) */
#define AQ_SIZE		4096	/* default size of aq */

/* IBDB */
#define IBDB_OPEN_TAS	32	/* max number of open tas before commit */
#define IBDB_DELAY	1000	/* max time between commits (micro s) */

/* Maximum time in queue (DEFED) */
#define QM_TMO_RETURN	345600
#define QM_TMO_DELAY	14400

/* Maximum time in AQ (waiting for AR), must be larger than DNS timeout... */
#define AQR_AR_TMOUT	120

/*
**  Maximum time in AQ (waiting for DA result).
**  Could be a long mail, should be larger than the sum of all DA timeouts.
**  Maybe something like size of mail * min. transfer rate needs to be added.
*/

#define AQR_DA_TMOUT	600

/* Maximum time in AQ (waiting to be scheduled). */
#define AQR_SCHED_TMOUT		900
#define AQR_SCHED_TMOUT_FACT	60

#ifndef AQR_DSN_RCPTS_MAX
# define AQR_DSN_RCPTS_MAX	100
#endif

/*
**  For
**	A = MAX_SHIFT_TRY + log_2(INIT_DELAY_TRY)
**  this condition should hold:
**	2^A > MAX_NEXT_TRY && 2^(A-1) < MAX_NEXT_TRY
**  to avoid overflow.
*/

#define INIT_DELAY_TRY		128	/* Will be shifted at least once */
#define MIN_DELAY_NXT_TRY	256
#define MAX_DELAY_NXT_TRY	3600
#define MAX_SHIFT_TRY	5


/* Maximum time for a DSN to wait to be scheduled  */
#define QM_TMO_SCHED_DSN	1

/*
**  Delay time for scheduler for a destination for which the concurrency limit
**  is exceeded.
*/

#define QM_DELAY_TOO_MANY 300

/*
**  SMTPC (DA)
*/

/* initial number of concurrent connections to the same address */
#define DA_INIT_CONC_CONN	10

/* max. number of concurrent connections to the same address */
#define DA_MAX_CONC_CONN	100

/* maximum number of recipients per transaction */
#define DA_MAX_RCPTS_TA	1000

/*
**  SMTPS
*/

#define SS_MAX_OPEN_SE		100
#define SS_MAX_CONN_RATE	100
#define SS_CONNCTL_SIZE		256	/* size of connection control ht */

/* Time between cleanup runs for DEFEDB */
#define EDB_SWEEP_DELAY	600

/* min free disk space (KB) */
#define DISK_MIN_FREE	16 UNIT_MB
#define DISK_OK_FREE	32 UNIT_MB

#define SM_QMGR_MIN_THR	2
#define SM_QMGR_MAX_THR	6
#define SM_QMGR_MAX_FD	10

#endif /* SM_QMGRDEF_H */
