/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: mcpcnfdef.h,v 1.21 2005/10/04 18:44:37 ca Exp $
 */

#ifndef SM_MCPCNFDEF_H
#define SM_MCPCNFDEF_H 1

#include "sm/generic.h"
#include "sm/error.h"
#include "sm/pwd.h"
#include "sm/sm-conf.h"
#include "sm/net.h"

#if SM_MCPCNFDEF
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN
sm_conf_definition_T
const wait_names[]
#if SM_MCPCNFDEF
=
{
{ SM_CONF_DEF_MAGIC,
	"nostartaccept", sm_conf_type_choice_value, SE_FL_ACCEPT|SE_FL_W4REQ,
	0, NULL, 0, NULL, NULL, NULL,
	"wait for an incoming connection then start a process to handle it" },
{ SM_CONF_DEF_MAGIC,
	"accept",	sm_conf_type_choice_value, SE_FL_ACCEPT,
	0, NULL, 0, NULL, NULL, NULL,
	"bind to socket and start process which will handle connections"},
{ SM_CONF_DEF_MAGIC,
	"pass",		sm_conf_type_choice_value, SE_FL_PASS,
	0, NULL, 0, NULL, NULL, NULL,
	"bind to socket, start process which will handle connections, pass fd via pass_fd_socket"},
{ SM_CONF_DEF_MAGIC,
	"wait",		sm_conf_type_choice_value, SE_FL_WAIT,
	0, NULL, 0, NULL, NULL, NULL,
	"just start processes, wait for their termination"},
{ SM_CONF_DEF_MAGIC,
	"start_and_wait",	sm_conf_type_choice_value, SE_FL_WAIT,
	0, NULL, 0, NULL, NULL, NULL,
	"just start processes, wait for their termination"},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MCPCNFDEF */
;

/*
**  NOTE: See mcpcnfs.h!
**  Is there a way to generate this file from it?
*/

EXTERN
sm_conf_definition_T
mcp_defs[]
#if SM_MCPCNFDEF
=
{
#if 0
{ SM_CONF_DEF_MAGIC,
  "name",		sm_conf_type_string,
	offsetof(servtab_T, se_prg),		0,		 "",
	SM_CONF_FLAG_STRICTLY_REQUIRED	},
#endif /* 0 */
#if 0
{ SM_CONF_DEF_MAGIC,
  "protocol",		sm_conf_type_string,
	offsetof(servtab_T, se_proto),		0,		 "_" },
#endif /* 0 */

{ SM_CONF_DEF_MAGIC,
  "listen_socket",	sm_conf_type_union,
	offsetof(servtab_T, se_socket.sckspc_type),
	sizeof(sockspec_T),
	"inet", SM_CONF_FLAG_KEEP_DEFAULT, sock_spec_definitions,
	NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC,
  "min_processes",	sm_conf_type_u32,
	offsetof(servtab_T, se_minchild),	sizeof(int),	"1",
	0,	NULL,	NULL,	NULL,
	"minimum number of processes"	},
{ SM_CONF_DEF_MAGIC,
  "max_processes",	sm_conf_type_u32,
	offsetof(servtab_T, se_maxchild),	sizeof(int),	"1",
	0,	NULL,	NULL,	NULL,
	"maximum number of processes"	},
{ SM_CONF_DEF_MAGIC,
  "listen_len",	sm_conf_type_u32,
	offsetof(servtab_T, se_listen_len),	sizeof(int),	"64",
	0,	NULL,	NULL,	NULL,
	"backlog parameter for listen(2)"	},
{ SM_CONF_DEF_MAGIC,
  "pass_fd_socket",	sm_conf_type_string,
	offsetof(servtab_T, se_exsock),		0,		 "",
	0,	NULL,	NULL,	NULL,
	"path of Unix domain socket to exchange file descriptor"	},
{ SM_CONF_DEF_MAGIC,
  "user",		sm_conf_type_string,
	offsetof(servtab_T, se_user),		0,		 "",
	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL,	NULL,	NULL,
	"run process as user"	},
{ SM_CONF_DEF_MAGIC,
  "group",		sm_conf_type_string,
	offsetof(servtab_T, se_group),		0,		 "",
	0,	NULL,	NULL,	NULL,
	"run process as group"	},
{ SM_CONF_DEF_MAGIC,
  "restart_dependencies",	sm_conf_type_argv,
	offsetof(servtab_T, se_restartdep),	SM_MCP_MAXRESTARTDEP,	NULL,
	0,	NULL,	NULL,	NULL,
	"list of services to restart in case of failure"	},
{ SM_CONF_DEF_MAGIC,
  "pass_id",		sm_conf_type_string,
	offsetof(servtab_T, se_pass_id),	0,		 NULL,
	0,	NULL,	NULL,	NULL,
	"pass id to process in argument list with this option"	},
{ SM_CONF_DEF_MAGIC,
  "use_id_in_logfile_name",		sm_conf_type_bool,
	offsetof(servtab_T, se_logf_id),	sizeof(bool),	 "0",
	0,	NULL,	NULL,	NULL,
	"use id to create name of logfile: Logdir name id . log"	},
{ SM_CONF_DEF_MAGIC,
  "path",		sm_conf_type_string,
	offsetof(servtab_T, se_server),		0,		 NULL,
	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL,	NULL,	NULL,
	"path to program"	},
{ SM_CONF_DEF_MAGIC,
  "arguments",		sm_conf_type_string,
	offsetof(servtab_T, se_args),		0,		 NULL,
	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL,	NULL,	NULL,
	"arguments for program"	},
{ SM_CONF_DEF_MAGIC,
  "working_directory",		sm_conf_type_string,
	offsetof(servtab_T, se_workdir),		0,		 NULL,
	0,	NULL,	NULL,	NULL,
	"working directory (chdir(2))"	},
{ SM_CONF_DEF_MAGIC,
  "start_action",		sm_conf_type_choice,
	offsetof(servtab_T, se_flags),		sizeof(uint),
	"wait", SM_CONF_FLAG_STRICTLY_REQUIRED, wait_names,
	NULL,	NULL,
	"how to handle program"	},
{ SM_CONF_DEF_MAGIC,
  "mcp_type",		sm_conf_type_choice,
	offsetof(servtab_T, se_flags),		sizeof(uint),
	"wait", SM_CONF_FLAG_KEEP_DEFAULT, wait_names,
	NULL,	NULL,
	"how to handle program"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MCPCNFDEF */
;

#endif /* SM_MCPCNFDEF_H */
