/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: mapcnfdef.h,v 1.16 2005/08/17 23:39:32 ca Exp $
 */

#ifndef SM_MAPCNFDEF_H
#define SM_MAPCNFDEF_H 1

#include "sm/generic.h"
#include "sm/map.h"
#include "sm/mapcnf.h"
#include "sm/sm-conf.h"

/*
**  Problem: different maps need different parameters for open:
**  socketmap: use sockcnfdef?
**  sequence map: array of names?
**  hash: optional parameters, e.g., cache size?
**  should this be a union?
*/


#if SM_MAPCNFDEF
#define EXTERN
#else
#define EXTERN extern
#endif



EXTERN
sm_conf_definition_T const
mst_flag_names[]
#if SM_MAPCNFDEF
=
{
{ SM_CONF_DEF_MAGIC,
	"implicitly_match_detail",		sm_conf_type_choice_value,
	SM_MAPSPEC_FL_IMPLDET,
	0, NULL, 0, NULL, NULL, NULL,
	"implicitly match +detail without specifying +* or *"	},

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MAPCNFDEF */
;

EXTERN
sm_conf_definition_T
mst_hash_defs[]
#if SM_MAPCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "name",		sm_conf_type_section_title,
	offsetof(mapspec_T, mst_name),	0,
	NULL,	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "type",		sm_conf_type_string,
	offsetof(mapspec_T, mst_hash.mst_hash_type),	0,
	"hash",
	0, NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "file",		sm_conf_type_string,
	offsetof(mapspec_T, mst_hash.mst_hash_fn),	0,
	NULL,	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL, NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MAPCNFDEF */
;

EXTERN
sm_conf_definition_T
mst_bht_defs[]
#if SM_MAPCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "name",		sm_conf_type_section_title,
	offsetof(mapspec_T, mst_name),	0,
	NULL,	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "type",		sm_conf_type_string,
	offsetof(mapspec_T, mst_bht.mst_bht_type),	0,
	"bhtable",
	0, NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "file",		sm_conf_type_string,
	offsetof(mapspec_T, mst_bht.mst_bht_fn),	0,
	NULL,	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL, NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MAPCNFDEF */
;



EXTERN
sm_conf_definition_T
mst_socket_defs[]
#if SM_MAPCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "name",		sm_conf_type_section_title,
	offsetof(mapspec_T, mst_name),	0,
	NULL,	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "type",		sm_conf_type_string,
	offsetof(mapspec_T, mst_socket.mst_socket_type),	0,
	"socket",
	0, NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "mapname",		sm_conf_type_string,
	offsetof(mapspec_T, mst_socket.mst_socket_mapname),	0,
	NULL,	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "path",			sm_conf_type_string,
	offsetof(mapspec_T, mst_socket.mst_socket_path),	0,
	NULL,
	0, NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "address",		sm_conf_type_ipv4,
	offsetof(mapspec_T, mst_socket.mst_socket_ipv4),	sizeof(ipv4_T),
	NULL,
	0, NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "port",		sm_conf_type_u32,
	offsetof(mapspec_T, mst_socket.mst_socket_port),	sizeof(short),
	NULL,
	0, NULL, NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MAPCNFDEF */
;


EXTERN
sm_conf_definition_T
mst_seq_defs[]
#if SM_MAPCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "name",		sm_conf_type_section_title,
	offsetof(mapspec_T, mst_seq.mst_seq_name),	0,
	NULL,	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "type",		sm_conf_type_string,
	offsetof(mapspec_T, mst_seq.mst_seq_type),	0,
	"seq",
	0, NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "maps",		sm_conf_type_argv,
	offsetof(mapspec_T, mst_seq.mst_seq_maps),	0,
	NULL,	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL, NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MAPCNFDEF */
;


EXTERN
sm_conf_definition_T
mst_passwd_defs[]
#if SM_MAPCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "name",		sm_conf_type_section_title,
	offsetof(mapspec_T, mst_name),	0,
	NULL,	SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL, NULL, NULL, NULL },

{ SM_CONF_DEF_MAGIC, "type",		sm_conf_type_string,
	offsetof(mapspec_T, mst_passwd.mst_passwd_type),	0,
	"passwd",
	0, NULL, NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MAPCNFDEF */
;


EXTERN
sm_conf_definition_T
map_spec_defs[]
#if SM_MAPCNFDEF
=
{
	{ SM_CONF_DEF_MAGIC, "type", sm_conf_type_union_type,
		offsetof(mapspec_T, mst_kind), sizeof(mapspec_kind_T),
		NULL, 0, NULL, NULL, NULL, NULL
	},

	{ SM_CONF_DEF_MAGIC, "type", sm_conf_type_union_choice,
		MST_HASH, sizeof(mapspec_T),  "hash", 0,
		mst_hash_defs,
		NULL, NULL, NULL
	},

	{ SM_CONF_DEF_MAGIC, "type", sm_conf_type_union_choice,
		MST_HASH, sizeof(mapspec_T),  "bhtable", 0,
		mst_bht_defs,
		NULL, NULL, NULL
	},

	{ SM_CONF_DEF_MAGIC, "type", sm_conf_type_union_choice,
		MST_SOCKET, sizeof(mapspec_T), "socket", 0,
		mst_socket_defs,
		NULL, NULL, NULL
	},

	{ SM_CONF_DEF_MAGIC, "type", sm_conf_type_union_choice,
		MST_SEQUENCE, sizeof(mapspec_T),  "sequence", 0,
		mst_seq_defs,
		NULL, NULL, NULL
	},

	{ SM_CONF_DEF_MAGIC, "type", sm_conf_type_union_choice,
		MST_PASSWD, sizeof(mapspec_T),  "passwd", 0,
		mst_passwd_defs,
		NULL, NULL, NULL
	},

	/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MAPCNFDEF */
;

EXTERN
sm_conf_definition_T
map_definitions[]
#if SM_MAPCNFDEF
=
{

	{
		SM_CONF_DEF_MAGIC,
		"map declaration",
		sm_conf_type_union,
		offsetof(map_decl_T, mapdecl_maps),
		sizeof(mapspec_T),
		NULL,
		0,
		map_spec_defs,
		NULL,
		NULL,
		"maps"
	},

	{
		SM_CONF_DEF_MAGIC,
		"n",
		sm_conf_type_array_n,
		offsetof(map_decl_T, mapdecl_n),
		sizeof(uint),
		NULL,
		0,
		map_spec_defs,
		NULL,
		NULL,
		"number of maps (implicit)"
	},

	/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MAPCNFDEF */
;

EXTERN
sm_conf_definition_T
maps_spec_defs[]
#if SM_MAPCNFDEF
=
{

	{ SM_CONF_DEF_MAGIC, "map", sm_conf_type_array,
		0,	/* offset */
		0,	/* size (# of elements) */
		NULL,	/* default */
		SM_CONF_FLAG_MULTIPLE,
		map_definitions,
		NULL,  NULL,
		"Map Declarations"
	},

	/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_MAPCNFDEF */
;

#undef EXTERN

#endif /* SM_MAPCNFDEF_H */
