/*
 * Copyright (c) 2003 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: errlog.h,v 1.4 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_ERRLOG_H
#define SM_ERRLOG_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/log.h"

/* Error reporting functions defined in the sterror.c file */
void PRINTFLIKE(2, 3)
errlog_sys_report(sm_log_ctx_P lctx, const char *fmt, ...);
void PRINTFLIKE(2, 3)
errlog_sys_quit(sm_log_ctx_P lctx, const char *fmt, ...);
void PRINTFLIKE(2, 3)
errlog_sys_dump(sm_log_ctx_P lctx, const char *fmt, ...);
void PRINTFLIKE(2, 3)
errlog_report(sm_log_ctx_P lctx, const char *fmt, ...);
void PRINTFLIKE(2, 3)
errlog_quit(sm_log_ctx_P lctx, const char *fmt, ...);

#endif /* SM_ERRLOG_H */
