/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: greycnfdef.h,v 1.2 2005/08/05 20:52:29 ca Exp $
 */

#ifndef SM_GREYCNFDEF_H
#define SM_GREYCNFDEF_H 1

#include "sm/generic.h"
#include "sm/greyctl.h"
#include "sm/sm-conf.h"
#include "sm/sm-conf-time.h"

#if SM_GREYCNFDEF
#define EXTERN
#else
#define EXTERN extern
#endif

#if 0
EXTERN
sm_conf_definition_T const
greycnf_flag_names[]
#if SM_GREYCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "some_flag",	sm_conf_type_choice_value,
	GREY_CNF_FL_xyz,
	0, NULL, 0, NULL, NULL, NULL, "" },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_GREYCNFDEF */
;
#endif /* 0 */


EXTERN
sm_conf_definition_T
greycnf_defs[]
#if SM_GREYCNFDEF
=
{
{ SM_CONF_DEF_MAGIC, "grey_wait",	sm_conf_type_u32,
	offsetof(greycnf_T, greycnf_min_grey_wait),	sizeof(uint),
	SM_XSTR(GREY_MIN_WAIT),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"how long before greylisted can be \"confirmed\""	},

{ SM_CONF_DEF_MAGIC, "grey_expire",	sm_conf_type_u32,
	offsetof(greycnf_T, greycnf_max_grey_wait),	sizeof(uint),
	SM_XSTR(GREY_MAX_WAIT),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"timeout for greylisted entries (didn't \"confirm\" within that time)"
	},

{ SM_CONF_DEF_MAGIC, "white_expire",	sm_conf_type_u32,
	offsetof(greycnf_T, greycnf_white_expire),	sizeof(uint),
	SM_XSTR(GREY_WHITE_EXPIRE),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"expire whitelisted entries after this time if necessary"	},

{ SM_CONF_DEF_MAGIC, "white_timeout",	sm_conf_type_u32,
	offsetof(greycnf_T, greycnf_white_reconfirm),	sizeof(uint),
	SM_XSTR(GREY_WHITE_RECONFIRM),	0,	sm_conf_time_suffixes,
	NULL,	NULL,
	"force whitelisted entries to reconfirm after this time"	},

{ SM_CONF_DEF_MAGIC, "main_DB_name",		sm_conf_type_string,
	offsetof(greycnf_T, greycnf_grey_name),	0,
	GREY_MAIN_DB,
	0, NULL, NULL, NULL,
	"name of main database (including .db extension)"},

{ SM_CONF_DEF_MAGIC, "secondary_DB_name",	sm_conf_type_string,
	offsetof(greycnf_T, greycnf_grey_sname),	0,
	GREY_SEC_DB,
	0, NULL, NULL, NULL,
	"name of secondary database (including .db extension)"},

{ SM_CONF_DEF_MAGIC, "expire_limit",	sm_conf_type_u32,
	offsetof(greycnf_T, greycnf_limit),	sizeof(uint),
	SM_XSTR(GREY_LIMIT),	0,	NULL, NULL,	NULL,
	"try to expire entries when this limit is reached"	},

{ SM_CONF_DEF_MAGIC, "netmask",		sm_conf_type_u32,
	offsetof(greycnf_T, greycnf_netmask),	sizeof(ipv4_T),
	"0xFFFFFFFF",	0,	NULL, NULL,	NULL,
	"apply netmask to IPv4 address"	},

#if 0
{ SM_CONF_DEF_MAGIC, "flags",			sm_conf_type_choice,
	offsetof(greycnf_T, greycnf_flags),	sizeof(uint),
	NULL,	SM_CONF_FLAG_MULTIPLE|SM_CONF_FLAG_OR,	greycnf_flag_names,
	NULL,	NULL, "Flags for greylist handling" },
#endif /* 0 */

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_GREYCNFDEF */
;

#undef EXTERN

#endif /* SM_GREYCNFDEF_H */
