#ifndef _CTABLE_H_INCLUDED_
#define _CTABLE_H_INCLUDED_

#include "sm/rpool.h"

/*++
* NAME
*	ctable 5
* SUMMARY
*	cache manager
* SYNOPSIS
*	#include <ctable.h>
* DESCRIPTION
* .nf
*/

 /*
  * Interface of the cache manager. The structure of a cache is not visible
  * to the caller.
  */

#define	CTABLE struct ctable
typedef struct ctable ctable_T, *ctable_P;

typedef void *(*CTABLE_CREATE_FN) (const char *, void *);
typedef void (*CTABLE_DELETE_FN) (void *, void *);

typedef void (ct_walk_F)(const char *, const void *);

extern ctable_P 	 ctable_create(sm_rpool_P, unsigned, CTABLE_CREATE_FN, CTABLE_DELETE_FN, void *);
extern void		 ctable_free(ctable_P);
extern void		 ctable_walk(ctable_P, ct_walk_F *);
extern const void	*ctable_locate(ctable_P _cache, const char *_key);
extern const void	*ctable_find(ctable_P _cache, const char *_key);

/* LICENSE
* .ad
* .fi
*	The Secure Mailer license must be distributed with this software.
* AUTHOR(S)
*	Wietse Venema
*	IBM T.J. Watson Research
*	P.O. Box 704
*	Yorktown Heights, NY 10598, USA
*--*/

#endif
