#!/bin/sh
# $Id: t-owner-0.sh,v 1.21 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test owner- alias expansion
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
OUT="t-owner-0.out"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
user++:	local:
sender: local:
list0-user1: local:
list0-user2: local:
list3-user1: local:
list3-user2: local:
listl-user1: local:
listl-user2: local:
ownerlist0: local:
ownerlist1: local:
ownerlistl: local:
list0:     <list0-user1@local.dom> <list1@local.dom> <list0-user2@some.dom>
owner-list0:     ownerlist0
owner-list1:     ownerlist1
list1:     <list1-user1@remote.dom> <list1-user2@some.dom>
owner-list2@some.dom:     <ownerlist2somedom@some.dom>
list2@some.dom:     <list0@local.dom> <list1@local.dom> <list2-user0@some.dom>
owner-listl:     ownerlistl
listl:     <listl-user1@local.dom> <listl-user2@local.dom>
list3:     <list3-user1@local.dom> <list3-user2@some.dom>
owner-list3:     ownerlist3
list4:     <list4-user1@local.dom> <list0-user2@some.dom>
owner-list4:     ownerlist4
list4-user1: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	[${SM_LMTPIPV4D}]
some.dom	[127.0.0.1]
other.dom	[127.0.0.1]
some.dom	[127.0.0.1]
remote.dom	[127.0.0.1]
EOF

# ----------------------------------------
# test: send mail to local list, check Return-Path:

TEST=1
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -Ssender@local.dom -Rlistl@local.dom -E 0 -X 0 -A 1
then
  if test -s ${B1}
  then
    if ${GREP} '^Return-Path: <owner-listl@local.dom>' ${B1} >/dev/null
    then
      :
    else
      echo "$0: ${TEST}: ${GREP} failed"
      ERR=true
    fi
  else
    echo "$0: ${TEST}: ${B1} not found"
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

# ----------------------------------------
# test: send mail to list1, delivery via SMTP, hence no Return-Path: to check

TEST=2
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtp1.sh -r -3 lmtpsock -Ssender@local.dom -Rlist1@local.dom -E 2 -X 1 -A 1
then
  if test -s ${S1}
  then
    :
  else
    echo "$0: ${TEST}: ${S1} not found"
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${S1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

# ----------------------------------------
# test: send mail to list0

TEST=3
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtp1.sh -r -3 lmtpsock -Ssender@local.dom -Rlist0@local.dom -E 3 -X 1 -A 1
then
  if test -s ${S1}
  then
    :
  else
    echo "$0: ${TEST}: ${S1} not found"
    ERR=true
  fi
  if test -s ${B1}
  then
    if ${GREP} '^Return-Path: <owner-list0@local.dom>' ${B1} >/dev/null
    then
      :
    else
      echo "$0: ${TEST}: ${GREP} failed"
      ERR=true
    fi
  else
    echo "$0: ${TEST}: ${B1} not found"
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${S1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

# ----------------------------------------
# test: send mail to list2; two remote deliveries, one local

TEST=4
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

# XREF: SMARCNF_FL_ALI_ALL
if ${SHELL} ${SD}/smtp1.sh -r -3 lmtpsock -a '-A 4' -Ssender@local.dom -Rlist2@some.dom -E 4 -X 3 -A 1
then
  if test ! -s ${S1}
  then
    echo "$0: ${TEST}: ${S1} not found"
    ERR=true
  fi
  if test ! -s ${S2}
  then
    echo "$0: ${TEST}: ${S2} not found"
    ERR=true
  fi
  if test -s ${B1}
  then
    if ${GREP} '^Return-Path: <owner-list0@local.dom>' ${B1} >/dev/null
    then
      :
    else
      echo "$0: ${TEST}: ${GREP} failed"
      ERR=true
    fi
  else
    echo "$0: ${TEST}: ${B1} not found"
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${S1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

# ----------------------------------------
# test: send mail to local list and local address, check Return-Path:

TEST=5
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

P1=false
P2=false
if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -Ssender@local.dom -R"listl@local.dom -Ruser+5@local.dom" -E 0 -X 0 -A 1
then
  for F in ${B1} ${B2}
  do
    if test -s ${F}
    then
      if ${GREP} '^Return-Path: <owner-listl@local.dom>' ${F} >/dev/null
      then
        if ${P1}
        then
          echo "$0: ${TEST}: ${GREP} 1 failed"
          ERR=true
        else
          P1=true
        fi
      else
        if ${GREP} '^Return-Path: <sender@local.dom>' ${F} >/dev/null
        then
          if ${P2}
          then
            echo "$0: ${TEST}: ${GREP} already found"
            ERR=true
          else
            P2=true
          fi
        else
          echo "$0: ${TEST}: ${GREP} 2 failed"
          ERR=true
        fi
      fi
    else
      ERR=true
    fi
  done
  ${P1} || ERR=true
  ${P2} || ERR=true
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

# ----------------------------------------
# test: send mail to list1 and remote address, delivery via SMTP,
# hence no Return-Path: to check

TEST=6
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtp1.sh -r -3 lmtpsock -Ssender@local.dom -R"list1@local.dom -Rtest6@some.dom" -E 3 -X 2 -A 1
then
  if test ! -s ${S1}
  then
    echo "$0: ${TEST}: ${S1} not found"
    ERR=true
  fi
  if test ! -s ${S2}
  then
    echo "$0: ${TEST}: ${S2} not found"
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${S1} ${S2}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi


# ----------------------------------------
# test: send mail to list0 and list4

TEST=7
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

P1=false
P2=false
if ${SHELL} ${SD}/smtp1.sh -r -3 lmtpsock -Ssender@local.dom -R"list0@local.dom -Rlist4@local.dom" -E 4 -X 1 -A 1
then
  if test ! -s ${S1}
  then
    echo "$0: ${TEST}: ${S1} not found"
    ERR=true
  fi
  if test ! -s ${S2}
  then
    echo "$0: ${TEST}: ${S2} not found"
    ERR=true
  fi

  for F in ${B1} ${B2}
  do
    if test -s ${F}
    then
      if ${GREP} '^Return-Path: <owner-list0@local.dom>' ${F} >/dev/null
      then
        if ${P1}
        then
          echo "$0: ${TEST}: ${GREP} P1 already found"
          ERR=true
        else
          P1=true
        fi
      else
        if ${GREP} '^Return-Path: <owner-list4@local.dom>' ${F} >/dev/null
        then
          if ${P2}
          then
            echo "$0: ${TEST}: ${GREP} P2 already found"
            ERR=true
          else
            P2=true
          fi
        else
          echo "$0: ${TEST}: ${GREP} failed"
          ERR=true
        fi
      fi
    else
      echo "$0: ${TEST}: ${F} not found"
      ERR=true
    fi
  done
  ${P1} || ERR=true
  ${P2} || ERR=true

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

# ----------------------------------------
# test: send mail to list0, list4, local and remote recipient

TEST=8
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

if ${SHELL} ${SD}/smtp1.sh -r -3 lmtpsock -Ssender@local.dom -R"list0@local.dom -Rlist4@local.dom -Ruser+8@local.dom -Rtest8@some.dom" -E 5 -X 1 -A 1
then
  for F in ${S1} ${S2} ${S3} ${S4}
  do
    if test ! -s ${F}
    then
      echo "$0: ${TEST}: ${F} not found"
      ERR=true
    fi
  done

  ${CAT} ${B1} ${B2} ${B3} | ${GREP} '^Return-Path: ' | sort -u > ${OUT}
  LINES=`wc -l < ${OUT}`
  if test ${LINES} -eq 3
  then
    if ${GREP} '^Return-Path: <owner-list0@local.dom>' ${OUT} >/dev/null
    then
      :
    else
      echo "$0: ${TEST}: ${GREP} 1 failed"
      ERR=true
    fi
    if ${GREP} '^Return-Path: <owner-list4@local.dom>' ${OUT} >/dev/null
    then
      :
    else
      echo "$0: ${TEST}: ${GREP} 2 failed"
      ERR=true
    fi
    if ${GREP} '^Return-Path: <sender@local.dom>' ${OUT} >/dev/null
    then
      :
    else
      echo "$0: ${TEST}: ${GREP} 3 failed"
      ERR=true
    fi
  else
    echo "$0: ${TEST}: ${LINES} != 3"
    ERR=true
  fi

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi


rm -f ${MTMAP} ${ALIMAP}
# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
