#!/bin/sh
# $Id: t-multda-0.sh,v 1.15 2005/08/25 20:24:16 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test program running the full system, uses mcpmts.sh
# This test starts several smtpc's (just for testing, only one will be used)
# ----------------------------------------
#
test -s stop && exit 1
#

# source directory of this (and other) shell script
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

# cd to right directory
cd ../qmgr || exit 1

SKIP=""
ERRS=0

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# create directory to pass socket
if test -d smtps
then
  :
else
  mkdir smtps
fi

# clean up before running tests
rm -f ${MTMAP} ${ACCMAP} ${QMGRCONFMAP} ${ALIMAP}

TEST=1
# ----------------------------------------
# test 1: two smtpc instances
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
${CAT} >${SMXCNF} <<EOF
smtps { log_level = 12;pass_fd_socket = smtps/smtpsfd; wait_for_server=4;
	listen_socket { type=inet; port=${SRVPORT}; }
	start_action = pass; user = ${USER};
	path = ../smtps/smtps;
	arguments = "smtps -f ${SMXCNF} ${SM_SERVER_OPTIONS}";
}
smtpc da1 { log_level = 12;remote_port = ${SNKPORT}; wait_for_server=4;
	start_action = wait; user = ${USER}; pass_id = -i;
	path = "../smtpc/smtpc"; arguments = "smtpc -N da1 -f ${SMXCNF}";
}
smtpc da2 { log_level = 12;remote_port = ${SNKPORT}; wait_for_server=4;
	start_action = wait; user = ${USER}; pass_id = -i;
	path = "../smtpc/smtpc"; arguments = "smtpc -N da2 -f ${SMXCNF}";
}
qmgr { log_level = 12;wait_for_server=4; wait_for_client=4; 
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,smtpc,smar, };
	path = "../qmgr/qmgr"; arguments = "qmgr -f ${SMXCNF}";
}
smar { log_level = 12;
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,qmgr };
	path = "../smar/smar"; arguments = "smar -f ${SMXCNF}";
}
EOF

for i in smar smtps da1 da2 qmgr
do
  cp /dev/null ${i}.log
done

${SHELL} ${SD}/mcpmts.sh -1 $@ || exit 1

# it seems smtps cannot bind to socket if the next test starts immediately
if test X"`uname`" = "XLinux"
then
  sleep 2
fi
fi

TEST=2
# ----------------------------------------
# test 2: one smtpc instance, two processes
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
${CAT} >${SMXCNF} <<EOF
smtps { log_level = 12;pass_fd_socket = smtps/smtpsfd; wait_for_server=4;
	listen_socket {type=inet;port=${SRVPORT};}
	start_action = pass; user = ${USER};
	path = ../smtps/smtps;
	arguments = "smtps -f ${SMXCNF} ${SM_SERVER_OPTIONS}";
}
smtpc { log_level = 12;remote_port = ${SNKPORT}; wait_for_server=4;
	min_processes = 2; max_processes = 2;
	start_action = wait; user = ${USER}; pass_id = -i;
	use_id_in_logfile_name = true;
	path = "../smtpc/smtpc"; arguments = "smtpc -f ${SMXCNF}";
}
qmgr { log_level = 12;wait_for_server=4; wait_for_client=4; 
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,smtpc,smar, };
	path = "../qmgr/qmgr"; arguments = "qmgr -f ${SMXCNF}";
}
smar { log_level = 12;
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,qmgr };
	path = "../smar/smar"; arguments = "smar -f ${SMXCNF}";
}
EOF

for i in smar smtps smtpc1 smtpc2 qmgr
do
  cp /dev/null ${i}.log
done

${SHELL} ${SD}/mcpmts.sh -1 $@ || exit 1

for i in smtpc1 smtpc2
do
  test -s ${i}.log || ERRS=`expr ${ERRS} + 1 `
done

# it seems smtps cannot bind to socket if the next test starts immediately
if test X"`uname`" = "XLinux"
then
  sleep 2
fi

fi

TEST=3
# ----------------------------------------
# test 3: two smtpc instances, two processes each
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
${CAT} >${SMXCNF} <<EOF
smtps { log_level = 12;pass_fd_socket = smtps/smtpsfd; wait_for_server=4;
	listen_socket {type=inet;port=${SRVPORT};}
	start_action = pass; user = ${USER};
	path = ../smtps/smtps;
	arguments = "smtps -f ${SMXCNF} ${SM_SERVER_OPTIONS}";
}
smtpc da1 { log_level = 12;remote_port = ${SNKPORT}; wait_for_server=4;
	min_processes = 2; max_processes = 2;
	start_action = wait; user = ${USER}; pass_id = -i;
	path = "../smtpc/smtpc"; arguments = "smtpc -N da1 -f ${SMXCNF}";
}
smtpc da2 { log_level = 12;remote_port = ${SNKPORT}; wait_for_server=4;
	min_processes = 2; max_processes = 2;
	start_action = wait; user = ${USER}; pass_id = -i;
	path = "../smtpc/smtpc"; arguments = "smtpc -N da2 -f ${SMXCNF}";
}
qmgr { log_level = 12;wait_for_server=4; wait_for_client=4; 
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,smtpc,smar, };
	path = "../qmgr/qmgr"; arguments = "qmgr -f ${SMXCNF}";
}
smar { log_level = 12;
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,qmgr };
	path = "../smar/smar"; arguments = "smar -f ${SMXCNF}";
}
EOF

for i in smar smtps da1 da2 qmgr
do
  cp /dev/null ${i}.log
done

${SHELL} ${SD}/mcpmts.sh -1 $@ || exit 1

# it seems smtps cannot bind to socket if the next test starts immediately
if test X"`uname`" = "XLinux"
then
  sleep 2
fi
fi

exit ${ERRS}
