#!/bin/sh
# $Id: t-mts-icr.sh,v 1.21 2005/09/01 21:13:15 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test incoming connection rate restriction.
# uses smtp1.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
SCRIPTS=`cd ${SD} && pwd`
MM=../libsmmap/t-mm
I=""
ERRS=0
SKIP=""

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

killit()
{
rm -f ${QMGRCONFMAP}
exit 1
}

# create restrictions
${CAT} > ${QMGRCONF} <<EOF
icr:127.0.0.1	2
icm:127.0.0.1	3
EOF
# create map
rm -f ${QMGRCONFMAP}
${MM} -t'	' -F ${QMGRCONFMAP} < ${QMGRCONF}
rm -f ${MTMAP}
trap killit 2

# run some test programs
# Note: when testing rates consider that there is one connection at
# the begin to see whether SMTPS is running!

# ----------------------------------------
# 
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtp1.sh -c '-d 5' $@ -A 5 -E 5 -S"a@b.c" -R"x@y.z" -t 5 -T 5
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    ERRS=`expr ${ERRS} + 1 `
    ${VERBOSE} && echo "test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# create restrictions
${CAT} > ${QMGRCONF} <<EOF
icr:127.0.0.1	5
icm:127.0.0.1	3
EOF
# create map
rm -f ${QMGRCONFMAP}
${MM} -t'	' -F ${QMGRCONFMAP} < ${QMGRCONF}

# ----------------------------------------
# 
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtp1.sh -W 1 -c '-d 5' $@ -A 15 -E 15 -S"a@b.c" -R"x@y.z" -t 5 -T 5
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    ERRS=`expr ${ERRS} + 1 `
    ${VERBOSE} && echo "test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

rm -f ${QMGRCONFMAP}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
