#!/bin/sh
# $Id: t-mts-grey-0.sh,v 1.7 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test greylisting
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

# this is a "slow" test?
if test X"${SM_NO_SLOW_TEST}" != "X"
then
  echo "$0: SKIPPED {SM_NO_SLOW_TEST}"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`
SRCPRG=${STE}/smtpc2

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

# create empty access map
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < /dev/null

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 14; nameserver = ${NS};
greylisting { grey_wait=10s; grey_expire=30s; }
}
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
flags = {access,greylisting};
daemon_address = localhost:${SRVPORT};
relay_from = "no.host";
relay_to = "local.host";
wait_for_server=4;
}
EOF

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}

${CAT} > ${MT} <<EOF
local.host	[127.0.0.1]
y.z		[127.0.0.1]
local.domain	lmtp:
EOF

# ----------------------------------------
# try to send a message: greylisted twice, then accepted
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
rm -f grey_grey_m.db grey_grey_s.db
ERR=false
SENDER=sender${TEST}@y.z
RCPT="-Runknown@local.domain -Ruser@local.domain"
if ${SHELL} ${SD}/smtpcnf.sh -z -S${SENDER} ${RCPT} -E 0 -X 0 -A 0
then
  sleep 1
  if ${SRCPRG} -r ${H}:${SRVPORT} -f"${SENDER}" ${RCPT} > ${CLTL} 2>&1
  then
    # check that no mail has been sent
    ${GREP} "total=0 " ${CLTL} >/dev/null || ERR=true
  else
    :
  fi

  sleep 11
  if ${SRCPRG} -r ${H}:${SRVPORT} -f"${SENDER}" ${RCPT} > ${CLTL} 2>&1
  then
    # check that mail has been sent
    ${GREP} "total=1 " ${CLTL} >/dev/null || ERR=true
  else
    :
  fi

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi

${SD}/stopmts.sh
fi

# ----------------------------------------
# try to send a message: greylisted but recipient is invalid anyway
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS};
greylisting { grey_wait=10s; grey_expire=30s; }
}
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps { Log_Level = 14;
flags = {access,delay_checks,greylisting};
daemon_address = localhost:${SRVPORT};
relay_from = "no.host";
relay_to = "local.host";
wait_for_server=4;
}
EOF

rm -f grey_grey_m.db grey_grey_s.db
ERR=false
SENDER=sender${TEST}@y.z
RCPT=unknown@local.domain
if ${SHELL} ${SD}/smtpcnf.sh -Z 'smtpc2' -c '-E' -S${SENDER} -R${RCPT} -E 0 -X 0 -A 0
then
  if ${GREP} 'RCPT=error, text=5' ${CLTL} >/dev/null
  then
    :
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi

# ----------------------------------------
# send a message: greylisted but client IP is whitelisted
TEST=3
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS};
greylisting { grey_wait=10s; grey_expire=30s; }
}
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps { Log_Level = 14;
flags = {access,delay_checks,greylisting};
daemon_address = localhost:${SRVPORT};
relay_from = "127\.0\.0\.1";
relay_to = "local.host";
wait_for_server=4;
}
EOF

# create access map
${CAT} > ${ACC} <<EOF
cltaddr:${SM_LOCALHOST}	ok
EOF
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < ${ACC}

rm -f grey_grey_m.db grey_grey_s.db
ERR=false
SENDER=sender${TEST}@y.z
RCPT=user@local.host
if ${SHELL} ${SD}/smtpcnf.sh -Z 'smtpc2' -c '-E' -S${SENDER} -R${RCPT} -E 1 -X 1 -A 1
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi

# ----------------------------------------
# send a message: greylisting requested by SMTPS but not configured in SMAR
TEST=4
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps { Log_Level = 14;
flags = {access,delay_checks,greylisting};
daemon_address = localhost:${SRVPORT};
relay_from = "no.host";
relay_to = "local.host";
wait_for_server=4;
}
EOF

rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < /dev/null

rm -f grey_grey_m.db grey_grey_s.db
ERR=false
SENDER=sender${TEST}@y.z
RCPT=user@local.host
if ${SHELL} ${SD}/smtpcnf.sh -Z 'smtpc2' -c '-E' -S${SENDER} -R${RCPT} -E 1 -X 1 -A 1
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi



# ----------------------------------------
rm -f ${ACCMAP} ${ALIMAP} ${MTMAP}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
