#!/bin/sh
# $Id: t-mts-acc-6.sh,v 1.5 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test access map restrictions: implicitly_match_detail
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

# create restrictions
${CAT} > ${ACC} <<EOF
cltaddr:${SM_LOCALHOST}	relay
EOF
# create map
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < ${ACC}

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 15; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }

smtps {
Log_Level = 12;
flags = {access, implicitly_match_detail};
daemon_address = localhost:${SRVPORT};
relay_from = "No.host.";
relay_to = "No.host.";
wait_for_server=4;
}
EOF

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}

${CAT} > ${MT} <<EOF
local.host	lmtp:
EOF

# create restrictions
${CAT} > ${ACC} <<EOF
from:sender	reject
to:user	reject
EOF
# create map
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < ${ACC}

# run some test programs

# ----------------------------------------
# deny sender with +detail
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -Z 'smtpc2' -c '-E' -Ssender+${TEST}@sm9.org -Ruser@local.host -E 0 -X 0 -A 0
then
  if ${GREP} 'MAIL=error' ${CLTL} >/dev/null
  then
    :
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi

# ----------------------------------------
# deny user with +detail
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -Z 'smtpc2' -c '-E' -Sok${TEST}@sm9.org -Ruser+${TEST}@local.host -E 0 -X 0 -A 0
then
  if ${GREP} 'RCPT=error' ${CLTL} >/dev/null
  then
    :
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi


# ----------------------------------------
rm -f ${ACCMAP} ${ALIMAP} ${MTMAP}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
