#!/bin/sh
# $Id: t-daport-0.sh,v 1.11 2005/08/25 20:24:15 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test program running the full system, uses mcpmts.sh
# test port specification in mailertable.
# ----------------------------------------
#
test -s stop && exit 1
#

# source directory of this (and other) shell script
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

# cd to right directory
cd ../qmgr || exit 1

SHELL=/bin/sh
test -x /bin/ksh && SHELL=/bin/ksh

SKIP=""
VERBOSE=false
ERRS=0

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# create directory to pass socket
if test -d smtps
then
  :
else
  mkdir smtps
fi

rm -f ${MTMAP}
${CAT} > ${MT} <<EOF
b.c	${SNKPORT}^esmtp:[127.0.0.1]
x.z	${SNKPORT}^esmtp:[127.0.0.1]
EOF

TEST=1
# ----------------------------------------
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
${CAT} >${SMXCNF} <<EOF
smtps { log_level = 12;pass_fd_socket = smtps/smtpsfd; wait_for_server=4;
	listen_socket { type=inet; port=${SRVPORT}; }
	start_action = pass; user = ${USER};
	path = ../smtps/smtps;
	arguments = "smtps -f ${SMXCNF} ${SM_SERVER_OPTIONS}";
}
smtpc { log_level = 12;remote_port = 2525; wait_for_server=4;
	start_action = wait; user = ${USER};
	path = "../smtpc/smtpc"; arguments = "smtpc -f ${SMXCNF} -d 3";
}
qmgr { log_level = 12;wait_for_server=4; wait_for_client=4; 
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,smtpc,smar, };
	path = "../qmgr/qmgr"; arguments = "qmgr -f ${SMXCNF} -d 3";
}
smar { log_level = 12;
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,qmgr };
	path = "../smar/smar"; arguments = "smar -f ${SMXCNF} -d 4";
}
EOF

for i in smar smtps smtpc qmgr
do
  cp /dev/null ${i}.log
done

# ----------------------------------------
${SHELL} ${SD}/mcpmts.sh -1 $@ || ERRS=`expr ${ERRS} + 1 `
fi

rm -f ${MTMAP}

exit ${ERRS}
