#!/bin/sh
# $Id: t-bounce-7.sh,v 1.11 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test bounces; including text of bounces delivered via lmtp to smtps3
# uses MIME format for DSN
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
OK="t-bounce-7.ok"
OUT="t-bounce-7.out"

# depends on settings in include/sm/qmgrdef.h XREF
#define QCNF_FL_B_HDR		0x00000008	/* bounce: headers only */
#define QCNF_FL_B_DSN_MIME	0x00000010	/* bounce in MIME format */
QFLAGS=0x18

if test X"`uname`" != "XOSF1"
then
while getopts f:s:V FLAG
do
  case "${FLAG}" in
    f) QFLAGS="${OPTARG}";;
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
alias1: user+alias1
aliase3: <553@local.dom>
553: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

# run some test programs

# ----------------------------------------
# permanent failure from SMTP sink; create a bounce; check content
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -Ssender@local.dom -R552@local.host -i 10 -E 1 -X 0 -A 1 -s 10 -Q "-F ${QFLAGS}" -C '-d 4'
then
  if test -s ${B1}
  then
     # get the MIME delimiter
     DELIM=`${EGREP} '^Content-Type: multipart/mixed; boundary=' ${B1} |\
	${SED} -e 's|^Content-Type: multipart/mixed; boundary="\([^"]*\)".*$|\1|'`

     # remove some lines that vary between tests/systems
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' \
		> ${OUT}

     ${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>
MIME-Version: 1.0
Content-Type: multipart/mixed; boundary="${DELIM}"

This is a MIME-encapsulated message

--${DELIM}

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<552@local.host>
Remote-MTA: 127.0.0.1
Reason:
552 whatever
during RCPT


--${DELIM}
Content-Type: message/rfc822

EOF
    if ${DIFF} -w ${OK} ${OUT} >/dev/null
    then
      :
    else
      ERR=true
    fi

  else
     ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
