#!/bin/sh
# $Id: smtpf.sh,v 1.34 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
# test program running the full system:
# qmgr, smar, smtpc, smtps
# using smtps and smtpc from statethreads/examples as source/sink
# this program tests some failure modes, e.g., temporary/permanent
# errors from the sink.
#
test -s stop && exit 1
#
# source directory of this (and other) shell script
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
#
EDBOUT=edbr.out
EDBOK=edbr.ok
EDBRCPTS=edbr.rctps
EDBRCPT2=edbr.rctps.sort
EDBRCPTO=edbr.rctps.out
# default settings
TAS=1
THREADS=1
RCPTS=1
TOTAL=1
#TR=66 # without bounce
TR=75
DELAY_TRY=600
OKDELAY=""
SLEEP=1
INIT=true
SND=""
# debug flags
D="-d 5"
# server options
SRVOPTS=${SM_SERVER_OPTIONS}

# works only with ksh on OSF/1
if test X"`uname`" != "XOSF1"
then
while getopts d:Di:Io:s:V: FLAG
do
  case "${FLAG}" in
    d)
       D="-d ${OPTARG}"
       ;;
    D) INIT=false;;
    i)
       DELAY_TRY="${OPTARG}"
       ;;
    I) SND="0";;
    o)
       OKDELAY="-o ${OPTARG}"
       ;;
    s)
       SLEEP="${OPTARG}"
       ;;
    V)
       SRVOPTS="${OPTARG}"
       ;;
    ?)
       echo "$0: unknown option ${FLAG}"
       echo "$0: options:"
       exit 1
       ;;
  esac
done
shift `expr ${OPTIND} - 1`
TOTAL=`expr ${TAS} \* ${THREADS}`
fi
#
# setup/initialize system
. ${SD}/mta-setup.sh
#

killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall qmgr smar
fi
if test X"${SRVPID}" != "X"
then
  kill -TERM ${SRVPID}
fi
exit 1
}

SRVPID=""
# store the PIDs for the started programs
rm -f ${PIDS}
trap killit 2

# start SMTP sink
${STE}/smtps2 ${PIPELINING} ${OKDELAY} -i -l . -b ${H}:${SNKPORT} > ${SRVL} 2>&1 &
status=$?
SRVPID=$!
if test "x${status}" != "x0"
then
  echo "$0: FAIL: cannot start server ${status}"
  exit ${status}
fi
sleep 1

# version of output files
V=0
# path to programs
P=..
# file to override settings
# test -f options && . ./options
# go for it
${P}/smar/smar ${D} $@ > a${V}.log 2>&1 &
echo $! >> ${PIDS}
#${CHKD}/qmgr-running.sh "${SMARSOCK}" || killit
${P}/qmgr/qmgr -w ${W4S} -W ${W4C} ${D} $@ -D ${DELAY_TRY} > q${V}.log 2>&1 &
echo $! >> ${PIDS}
# wait a bit for startup such that the sockets are created
#export SMTPCSOCK
#${CHKD}/qmgr-running.sh || killit

${P}/smtpc/smtpc -w ${W4S} -l . -P ${SNKPORT} ${D} $@ > c${V}.log 2>&1 &
echo $! >> ${PIDS}
${P}/smtps/smtps -w ${W4S} ${SRVOPTS} -l . ${D} -b localhost:${SRVPORT} $@ > s${V}.log 2>&1 &
echo $! >> ${PIDS}

# check that the MTA is running
export SRVPORT P
${CHKD}/mta-running.sh || killit

rm -f ${EDBRCPTS}
SENDER="a@b.c"
# send messages
for R in "-R451@t00.x.z -R452@t00.x.z -R453@t00.x.z -Rok0@t00.x.y"	\
	"-R451@t01.x.z -R452@t01.x.z -Rok0@t01.x.y -R453@t01.x.z"	\
	"-R451@t02.x.z -Rok0@t02.x.y -R452@t02.x.z -R453@t02.x.z"	\
	"-Rok0@t03.x.y -R451@t03.x.z -R452@t03.x.z -R453@t03.x.z"	\
	"-Rok1@t04.x.y -Rok2@t04.x.z -R452@t04.x.z -R453@t04.x.z"	\
	"-Rok1@t05.x.y -R451@t05.x.z -Rok2@t05.x.z -R452@t05.x.z"	\
	"-Rok1@t06.x.y -R452@t06.x.z -Rok2@t06.x.z"	\
	"-Rok1@t07.x.y -Rok2@t07.x.z -R452@t07.x.z"	\
	"-R451@t08.x.z -R452@t08.x.z -Rok0@t08.x.y -R550@t08.x.z"	\
	"-R451@t09.x.z -R550@t09.x.z -Rok0@t09.x.y -R452@t09.x.z"	\
	"-R550@t10.x.z -R451@t10.x.z -Rok0@t10.x.y -R452@t10.x.z"	\
	"-R451@t11.x.z -Rok0@t11.x.y -R452@t11.x.z -R550@t11.x.z"	\
	"-Rok0@t12.x.y -R451@t12.x.z -R452@t12.x.z -R550@t12.x.z"	\
	"-Rok1@t13.x.y -Rok2@t13.x.z -R452@t13.x.z -R550@t13.x.z"	\
	"-Rok1@t14.x.y -R451@t14.x.z -Rok2@t14.x.z -R550@t14.x.z"	\
	"-Rok1@t15.x.y -R550@t15.x.z -Rok2@t15.x.z"	\
	"-Rok1@t16.x.y -Rok2@t16.x.z -R550@t16.x.z"	\
	"-Rok1@t17.x.y -Rok2@t17.x.z"
do
  if test X"${SND}" != "X"
  then
    SENDER="a-${SND}@b.c"
    SND=`expr ${SND} + 1 `
  fi
  if ${STE}/smtpc -r ${H}:${SRVPORT} -f${SENDER} ${R} > ${CLTL} 2>&1
  then
    echo ${R} | sed -e 's/-R/	rcpt=</g' -e 's/  */>\
/g' -e 's/$/>\
/' >> ${EDBRCPTS}
  else
    cat ${CLTL}
    ERRS=`expr ${ERRS} + 1 `
  fi
done
egrep -v '(ok|^$|<5)' ${EDBRCPTS} | sort > ${EDBRCPT2}
# exclude '<5' for MTA that can deliver bounces

sleep ${SLEEP}

# stop MTA components
for i in `cat pids`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall qmgr smar
fi

# send SMTP server a signal to dump its state
if kill -USR1 ${SRVPID}
then
  :
else
  echo "kill -USR1 failed: $?"
  exit 1
fi
sleep 2

# check state of SMTP server
if ${GREP} "^Address *${H}:${P}" ${SRVL} > /dev/null
then
  :
else
  echo "failed to listen on ${H}:${P}"
  ERRS=`expr ${ERRS} + 1 `
fi
if ${GREP} "^Thread.* 8/" ${SRVL} > /dev/null
then
  :
else
  echo "failed to start threads"
  ERRS=`expr ${ERRS} + 1 `
fi
# the number of requests can vary based on the scheduler...
RQS=`${GREP} "^Requests served *" ${SRVL} | sed -e 's/^Requests served *//'`
if test "${RQS}" -lt "${TOTAL}"
then
  echo "wrong number of requests: expected=${TOTAL} got=${RQS}"
  ERRS=`expr ${ERRS} + 1 `
fi
if ${GREP} "^Recipients *${TR}$" ${SRVL} > /dev/null
then
  :
else
  echo "wrong number of recipients: expected=${TR}"
  ${GREP} "^Recipients" ${SRVL}
  ERRS=`expr ${ERRS} + 1 `
fi
if ${GREP} "total=${TOTAL} " ${CLTL} > /dev/null
then
  :
else
  echo "wrong number of mails sent: expected=${TOTAL}"
  ${GREP} "total=" ${CLTL}
  ERRS=`expr ${ERRS} + 1 `
fi

# ----------------
kill -TERM ${SRVPID}

# ----------------
if ${IDBR0} >/dev/null
then
  if test "${ERRS}" = "0"
  then
    rm -f ibdd/ibd00000000*
  fi
else
  echo "t-idbr-0 failed"
  ERRS=`expr ${ERRS} + 1 `
fi

# ----------------
if ${EDBR} > ${EDBOUT} 2>&1
then
  :
else
  echo "${EDBR} failed"
  ERRS=`expr ${ERRS} + 1 `
fi
#if ../checks/t-edbr-0 |egrep -v 'time|(id|cdb)=' > ${EDBOUT} 2>&1
${GREP} rcpt= ${EDBOUT} | sort > ${EDBRCPTO} 2>&1
if diff ${EDBRCPTO} ${EDBRCPT2}
then
  :
else
  echo "recipients do not match"
  ERRS=`expr ${ERRS} + 1 `
fi

# ----------------
for i in a c q s
do
  if egrep "${ERRORPAT}" ${i}${V}.log
  then
    ERRS=`expr ${ERRS} + 1 `
  fi
done

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
