/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-strprintf.c,v 1.8 2005/04/14 17:14:02 ca Exp $")

#include "sm/limits.h"
#include "sm/io.h"
#include "sm/str.h"
#include "sm/rpool.h"
#include "sm/types.h"
#include "sm/test.h"

static void
cmp(sm_str_P str, char *r)
{
	if (!SM_TEST(strcmp((char *)sm_str_getdata(str), r) == 0))
		(void) sm_io_fprintf(smioerr, "got %s instead of %s\n",
				(char *)sm_str_getdata(str), r);
}

#define MAXL	128

static void
test(sm_rpool_P rpool)
{
	int i;
	sm_ret_T ret;
	sm_str_P str;
	char *r;
	sm_file_T file;
	char buf[MAXL];

	str = sm_str_new(rpool, 16, MAXL);
	SM_TEST(str != NULL);
	if (str == NULL)
		return;
	i = sm_str2file(str, &file);
	SM_TEST(i == SM_SUCCESS);
	if (i != SM_SUCCESS)
		return;

	sm_strprintf(str, "%d", 0);
	r = "0";
	cmp(str, r);

	sm_str_clr(str);
	sm_io_fprintf(&file, "%d", 0);
	r = "0";
	cmp(str, r);

	sm_str_clr(str);
	sm_strprintf(str, "%s%010d", "ibd", 1);
	r = "ibd0000000001";
	cmp(str, r);

	sm_str_clr(str);
	sm_io_fprintf(&file, "%s%010d", "ibd", 1);
	r = "ibd0000000001";
	cmp(str, r);

	sm_str_clr(str);
	sm_strprintf(str, "%s%010d", "ibd", 2);
	r = "ibd0000000002";
	cmp(str, r);

	sm_str_clr(str);
	sm_io_fprintf(&file, "%s%010d", "ibd", 2);
	r = "ibd0000000002";
	cmp(str, r);

	sm_str_clr(str);
	sm_strprintf(str, "%d", 123);
	r = "123";
	cmp(str, r);
	sm_strprintf(str, "%d", 123);
	r = "123123";
	cmp(str, r);

	sm_str_clr(str);
	sm_io_fprintf(&file, "%d", 123);
	r = "123";
	cmp(str, r);
	sm_io_fprintf(&file, "%d", 123);
	r = "123123";
	cmp(str, r);

	sm_str_clr(str);
	ret = sm_strprintf(str, "%4d", 123);
	SM_TEST(ret == 4);
	r = " 123";
	cmp(str, r);

	sm_str_clr(str);
	ret = sm_io_fprintf(&file, "%4d", 123);
	SM_TEST(ret == 4);
	r = " 123";
	cmp(str, r);

	sm_str_clr(str);
	buf[0] = '\0';
	for (i = 0; i < MAXL / 4; i++)
	{
		ret = sm_strprintf(str, "%4d", 1234);
		SM_TEST(ret == (i + 1) * 4);
		strlcat(buf, "1234", sizeof(buf));
		cmp(str, buf);
	}
	ret = sm_strprintf(str, "%4d", 1234);
	SM_TEST(ret > (int) sm_str_getmax(str));
	SM_TEST(sm_str_getlen(str) < sm_str_getmax(str));

	sm_str_clr(str);
	strlcpy(buf, "This is a nice test", sizeof(buf));
	ret = sm_strprintf(str, "%s", buf);
	SM_TEST(ret == (int) strlen(buf));
	cmp(str, buf);

	sm_str_clr(str);
	ret = sm_strprintf(str, "%s %s %s", buf, buf, buf);
	SM_TEST(ret == (int) strlen(buf) *3 + 2);

	sm_str_clr(str);
	ret = sm_io_fprintf(&file, "%s %s %s", buf, buf, buf);
	SM_TEST(ret == (int) strlen(buf) *3 + 2);

	sm_str_clr(str);
	sm_snprintf(buf, sizeof(buf), "%%%ds", MAXL + 2);
	ret = sm_strprintf(str, buf, "too long");
	SM_TEST(ret > (int) sm_str_getmax(str));

	sm_str_clr(str);
	i = sm_strprintf(str, "%#s", "abc");
	r = "abc";
	SM_TEST(i == (int) strlen(r));
	cmp(str, r);

	sm_str_clr(str);
	i = sm_strprintf(str, "%#s", "ab\tc");
	r = "ab%09c";
	SM_TEST(i == (int) strlen(r));
	cmp(str, r);

	sm_str_clr(str);
	i = sm_strprintf(str, "%#s", "ab%c");
	r = "ab%25c";
	SM_TEST(i == (int) strlen(r));
	cmp(str, r);

	sm_str_clr(str);
	i = sm_strprintf(str, "%#s", "ab\tc\001");
	r = "ab%09c%01";
	SM_TEST(i == (int) strlen(r));
	cmp(str, r);

	sm_str_clr(str);
	i = sm_strprintf(str, "%#.3s", "ab\tc\001");
	r = "ab_";
	SM_TEST(i == (int) strlen(r));
	cmp(str, r);


	sm_str_free(str);
}

int
main(int argc, char *argv[])
{
	sm_rpool_P rpool;

	sm_test_begin(argc, argv, "test strprintf");
	test(NULL);
	rpool = sm_rpool_new(NULL);
	SM_TEST(rpool != NULL);
	if (rpool != NULL)
	{
		test(rpool);
		sm_rpool_delete(rpool);
	}
	return sm_test_end();
}
