#!/bin/sh
# $Id: t-net-1.sh,v 1.11 2005/10/21 17:47:23 ca Exp $
# Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# more network tests: double buffering
#
test -s stop && exit 1
#
# set for verbose mode to -V...
V=""
SRV="error.srv"
CLT="error.clt"
rm -f ${SRV} ${CLT}
if test $# -ge 1
then
  VERBOSE=$1
fi
#
for prg in 0 1
do
./t-net-${prg} -s 5 -BB ${V} 2> ${SRV} &
sleep 1
./t-net-${prg} -c 10 -B ${V} 2> ${CLT}
wait
sleep 1
#
test "X" != "X${VERBOSE}" && echo "DBG: server reads twice"
if grep 'error in test' ${SRV}  >/dev/null
then
	echo ERROR
	cat ${SRV}
	exit 1
else
	test "X" != "X${VERBOSE}" && echo server ok
fi
if grep 'error in test' ${CLT}  >/dev/null
then
	echo ERROR
	cat ${CLT}
	exit 1
else
	test "X" != "X${VERBOSE}" && echo client ok
fi
rm -f ${SRV} ${CLT}

# ----
test "X" != "X${VERBOSE}" && echo "DBG: client sends twice"
./t-net-${prg} -s 10 -B ${V} 2> ${SRV} &
sleep 1
./t-net-${prg} -t 3 -c 5 -BB ${V} 2> ${CLT}
wait
if grep 'readsock: EOF' ${SRV}  >/dev/null
then
	test "X" != "X${VERBOSE}" && echo server ok
else
	echo ERROR
	echo SRV
	cat ${SRV}
	exit 1
fi
if grep 'readsock: .* type=3' ${CLT}  >/dev/null
then
	test "X" != "X${VERBOSE}" && echo client ok
else
	echo ERROR
	echo CLT
	cat ${CLT}
	exit 1
fi
rm -f ${SRV} ${CLT}

# ----
for R in BB BBBB BBBBBBBB
do
  # for L in 1000 100000 10000000
  for L in 1000 10000 100000
  do
    ./t-net-${prg} -s ${L} -${R} ${V} 2> ${SRV} &
    sleep 1
    ./t-net-${prg} -c ${L} -${R} ${V} 2> ${CLT}
    wait
    sleep 1
    #
    test "X" != "X${VERBOSE}" && echo "DBG: clt/srv: ${R}/${L}"
    if grep 'error in test' ${SRV}  >/dev/null
    then
    	echo ERROR
    	cat ${SRV}
    	exit 1
    else
    	test "X" != "X${VERBOSE}" && echo server ok
    fi
    if grep 'error in test' ${CLT}  >/dev/null
    then
    	echo ERROR
    	cat ${CLT}
    	exit 1
    else
    	test "X" != "X${VERBOSE}" && echo client ok
    fi
    rm -f ${SRV} ${CLT}
  done
done
done

exit 0
