/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-lists.c,v 1.7 2004/12/29 23:47:29 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/test.h"
#include "sm/queue.h"

#include <stdio.h>

struct entry
{
	int			item;
	TAILQ_ENTRY(entry)	entries;
} *n1, *n2, *np, *nn;

TAILQ_HEAD(fh, entry);

static void
test_lists(void)
{
	int old, count;
	struct fh head;

	TAILQ_INIT(&head);
	SM_TEST(TAILQ_EMPTY(&head));

	n1 = malloc(sizeof(*n1));
	SM_TEST(n1 != NULL);
	n1->item = 1;
	TAILQ_INSERT_HEAD(&head, n1, entries);
	SM_TEST(!TAILQ_EMPTY(&head));
	SM_TEST(TAILQ_LAST(&head, fh) == n1);

	n1 = malloc(sizeof(*n1));
	SM_TEST(n1 != NULL);
	n1->item = 128;
	TAILQ_INSERT_TAIL(&head, n1, entries);
	SM_TEST(TAILQ_LAST(&head, fh) == n1);

	n2 = malloc(sizeof(*n2));
	SM_TEST(n2 != NULL);
	n2->item = 196;
	TAILQ_INSERT_AFTER(&head, n1, n2, entries);
	SM_TEST(TAILQ_LAST(&head, fh) == n2);

	n2 = malloc(sizeof(*n2));
	SM_TEST(n2 != NULL);
	n2->item = 64;
	TAILQ_INSERT_BEFORE(n1, n2, entries);
	SM_TEST(TAILQ_LAST(&head, fh) != n2);

	old = -1;
	count = 0;
	TAILQ_FOREACH(np, &head, entries)
	{
		if (SmTestVerbose)
		{
			printf("Element\t%d: %4d\n", count, np->item);
		}
		SM_TEST(old < np->item);
		old = np->item;
		++count;
	}
	SM_TEST(count == 4);

	for (np = TAILQ_FIRST(&head); np != TAILQ_END(&head); np = nn)
	{
		nn = TAILQ_NEXT(np, entries);
		free(np);
	}
}

int
main(int argc, char *argv[])
{

	sm_test_begin(argc, argv, "test lists");
	test_lists();
	return sm_test_end();
}
