/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-dec-err.c,v 1.5 2005/09/06 17:29:47 ca Exp $")

#include <stdio.h>

#include "sm/error.h"
#include "sm/dns.h"
#include "sm/bdb.h"
#include "sm/rfc2821.h"
#include "sm/test.h"

static void
errtxt(void)
{
	sm_ret_T err;
	char *errtxt;
	char txt[256], buf[32];

	err = sm_error_perm(SM_EM_BDB, DB_KEYEMPTY);
	errtxt = smerr2txt(err);
	SM_TEST(strcmp(errtxt, "DB_KEYEMPTY") == 0);

	err = sm_error_perm(SM_EM_BDB, DB_KEYEMPTY);
	sm_snprintf(txt, sizeof(txt), "%m", err);
	SM_TEST(strcmp(txt, "DB_KEYEMPTY") == 0);

	err = sm_error_perm(SM_EM_BDB, DB_KEYEMPTY);
	sm_snprintf(txt, sizeof(txt), "stat=%M", err);
	SM_TEST(strcmp(txt, "stat=DB_KEYEMPTY, module=BDB") == 0);

	err = sm_err_perm(R2821_ERR_DOMAIN);
	errtxt = smerr2txt(err);
	SM_TEST(strcmp(errtxt, "domain part is empty") == 0);

	err = sm_err_perm(SM_E_NOMORE);
	errtxt = smerr2txt(err);
	SM_TEST(strcmp(errtxt, "no next entry") == 0);

	err = sm_err_perm(DNSR_NOTFOUND);
	errtxt = smerr2txt(err);
	SM_TEST(strcmp(errtxt, "DNS record not found (authorative)") == 0);

	err = sm_err_perm(SM_CNF_E_CHAR_OVERFLOW);
	errtxt = smerr2txt(err);
	SM_TEST(strcmp(errtxt, "character constant too large") == 0);

	err = sm_err_perm(R2821_ERR_DOMAIN);
	sm_snprintf(txt, sizeof(txt), "stat=%.10M", err);
	SM_TEST(strcmp(txt, "stat=domain par") == 0);

	err = sm_error_perm(SM_EM_IO, SM_E_LASTCODE + 1);
	sm_snprintf(txt, sizeof(txt), "%m", err);
	sm_snprintf(buf, sizeof(buf), "%r", err);
	SM_TEST(strcmp(txt, buf) == 0);

/*

	err = sm_err_perm();
	errtxt = smerr2txt(err);
	SM_TEST(strcmp(errtxt, "") == 0);
*/
}

int
main(int argc, char *argv[])
{
	sm_test_begin(argc, argv, "test dec-err");
	errtxt();
	return sm_test_end();
}
