/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-arpadate.c,v 1.6 2004/12/29 23:47:29 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/time.h"
#include "sm/test.h"
#include "sm/io.h"

static int Verbose = 0;

static time_t times[] = {1, 100, 1000, 10000, 100000,
	1000000, 2000000, 3000000, 4000000, 5000000,
	6000000, 7000000, 8000000, 9000000,

	10000000, 20000000, 30000000, 40000000, 50000000,
	60000000, 70000000, 80000000, 90000000,

	100000000, 200000000, 300000000, 400000000, 500000000,
	600000000, 700000000, 800000000, 900000000,

	0 }; /* 0 must be last! */

static void
test_harness(void)
{
	int i;
	sm_ret_T ret;
	sm_str_P s ;
	time_t now;
#if SM_USE_PTHREADS
	struct tm tm;
#endif /* SM_USE_PTHREADS */
	struct tm *tm_now;
	char ft[128];

	s = sm_str_new(NULL, 50, 64);
	SM_TEST(s != NULL);
	now = time(NULLT);
	i = 0;
	do
	{
		sm_str_clr(s);
		ret = arpadate(&now, s);
		SM_TEST(ret == SM_SUCCESS);
		if (Verbose > 0)
			sm_io_fprintf(smioout, "time '%S'\n", s);

#if HAVE_STRFTIME
#if SM_USE_PTHREADS
		tm_now =  localtime_r(&now, &tm);
#else /* SM_USE_PTHREADS */
		tm_now =  localtime(&now);
#endif /* SM_USE_PTHREADS */
# if HAVE_STRFTIME_E
		strftime(ft, sizeof(ft), "%a, %e %b %Y %H:%M:%S", tm_now);
# else /* HAVE_STRFTIME_E */
		strftime(ft, sizeof(ft), "%a, %d %b %Y %H:%M:%S", tm_now);
		if (ft[5] == '0')
			ft[5] = ' ';
# endif /* HAVE_STRFTIME_E */
		SM_TEST(strncmp(ft, (char *) sm_str_data(s), strlen(ft)) == 0);
		if (Verbose > 0)
			sm_io_fprintf(smioout, "ftim '%s'\n", ft);
#endif /* HAVE_STRFTIME */

		now = times[i++];
	} while (now != 0);

	SM_STR_FREE(s);
	if (Verbose > 0)
		sm_io_flush(smioout);
}

int
main(int argc, char *argv[])
{
	int r;

	while ((r = getopt(argc, argv, "V")) != -1)
	{
		switch (r)
		{
		  case 'V':
			Verbose++;
			break;
		  default:
/*
			usage(argv[0]);
*/
			return 1;
		}
	}

	sm_test_begin(argc, argv, "test arpadate");
	test_harness();
	return sm_test_end();
}
