/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-dbgcat.c,v 1.3 2004/12/26 04:08:53 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/memops.h"
#include "sm/util.h"
#include "sm/test.h"

/*
**  test setting debug levels in an array
**	sm_set_dbgcats()
*/

#define DBG_LEN	32
uint dbg[DBG_LEN];
int Verbose = 0;

static void
dbginit(void)
{
	sm_memzero(dbg, sizeof(dbg));
}

static void
dbglc(void)
{
	sm_ret_T ret;
	uint i;
	char *buf;
	char *ptr;

	buf = "1";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(dbg[1] == 1);

	buf = "1-3";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret == SM_SUCCESS);
	for (i = 1; i <= 3; i++)
		SM_TEST(dbg[i] == 1);

	buf = "1-3.5";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret == SM_SUCCESS);
	for (i = 1; i <= 3; i++)
		SM_TEST(dbg[i] == 5);

	buf = "1-3.5,4-9.3,12.99";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret == SM_SUCCESS);
	for (i = 1; i <= 3; i++)
		SM_TEST(dbg[i] == 5);
	for (i = 4; i <= 9; i++)
		SM_TEST(dbg[i] == 3);
	SM_TEST(dbg[12] == 99);

	buf = "1-3.4,5.3,9-11";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret == SM_SUCCESS);
	for (i = 1; i <= 3; i++)
		SM_TEST(dbg[i] == 4);
	SM_TEST(dbg[5] == 3);
	for (i = 9; i <= 11; i++)
		SM_TEST(dbg[i] == 1);

	buf = "1-";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret != SM_SUCCESS);

	buf = "1-33";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret != SM_SUCCESS);

	buf = "32-33";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret != SM_SUCCESS);

	buf = "31-30";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret != SM_SUCCESS);

	buf = "-30";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret != SM_SUCCESS);

	buf = "-";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret != SM_SUCCESS);

	buf = "";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret != SM_SUCCESS);

	buf = "3a-33";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret != SM_SUCCESS);

	buf = "3-3/4";
	ptr = buf;
	dbginit();
	ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
	SM_TEST(ret != SM_SUCCESS);

}

int
main(int argc, char *argv[])
{
	sm_ret_T ret;
	int c;
	char *prg, *ptr;

	opterr = 0;
	Verbose = 0;
	prg = argv[0];
	while ((c = getopt(argc, argv, "d:V")) != -1)
	{
		switch (c)
		{
		  case 'd':
			dbginit();
			ptr = optarg;
			ret = sm_set_dbgcats(&ptr, dbg, SM_ARRAY_SIZE(dbg));
			SM_TEST(ret == SM_SUCCESS);
			break;
		  case 'V':
			++Verbose;
			break;
		  default:
			exit(1);
		}
	}
	argc -= optind;
	argv += optind;
	sm_test_begin(argc, argv, "test debug cats");
	dbglc();
	return sm_test_end();
}
