#
#  This Makefile is designed to work on the old "make" program.  It does
#  not use the obj subdirectory.  It also does not install documentation
#  automatically -- think of it as a quick start for sites that have the
#  old make program (I recommend that you get and port the new make if you
#  are going to be doing any signficant work on sendmail).
#
#	NCR SVR4 MP-RAS 3.x support from
#	Tom Moore <tmoore@fievel.DaytonOH.NCR.COM>.
#
#	@(#)Makefile.NCR.MP-RAS.3.x	8.6 (Berkeley) 7/7/97
#

# use O=-O (usual) or O=-g (debugging)
O=	-O2

# define the database mechanisms available for map & alias lookups:
#	-DNDBM -- use new DBM
#	-DNEWDB -- use new Berkeley DB
#	-DNIS -- include NIS support
# The really old (V7) DBM library is no longer supported.
# See READ_ME for a description of how these flags interact.
#
DBMDEF=	-DNDBM

# environment definitions (e.g., -D_AIX3)
ENVDEF=	-DNCR_MP_RAS3

# see also conf.h for additional compilation flags

# include directories
INCDIRS=-I/usr/include -I/usr/ucbinclude

# loader options
LDOPTS=

# library directories
LIBDIRS=-L/usr/ucblib

# libraries required on your system
LIBS=	-lsocket -lnsl -lresolv -lelf -lc -lucb

# location of sendmail binary (usually /usr/sbin or /usr/lib)
BINDIR=	${DESTDIR}/usr/ucblib

# location of sendmail.st file (usually /var/log or /usr/lib)
STDIR=	${DESTDIR}/var/ucblib

# location of sendmail.hf file (usually /usr/share/misc or /usr/lib)
HFDIR=	${DESTDIR}/usr/ucblib

# additional .o files needed
OBJADD=

###################  end of user configuration flags  ######################

CFLAGS=	-I. $O ${INCDIRS} ${DBMDEF} ${ENVDEF}

OBJS=	alias.o arpadate.o clock.o collect.o conf.o convtime.o daemon.o \
	deliver.o domain.o envelope.o err.o headers.o macro.o main.o \
	map.o mci.o mime.o parseaddr.o queue.o readcf.o recipient.o \
	safefile.o savemail.o srvrsmtp.o stab.o stats.o sysexits.o \
	trace.o udb.o usersmtp.o util.o version.o ${OBJADD}

LINKS=	${DESTDIR}/usr/ucb/newaliases ${DESTDIR}/usr/ucb/mailq \
	${DESTDIR}/usr/ucb/hoststat ${DESTDIR}/usr/ucb/purgestat
INSTALL=/usr/ucb/install
BINOWN=	root
BINGRP=	kmem
BINMODE=6555

ALL=	sendmail aliases.0 mailq.0 newaliases.0 sendmail.0

all: ${ALL}

sendmail: ${BEFORE} ${OBJS}
	${CC} -o sendmail ${LDOPTS} ${OBJS} ${LIBDIRS} ${LIBS}

NROFF=	/usr/ucb/nroff -h
#NROFF=	groff -Tascii
MANDOC=	-mandoc

aliases.0: aliases.5
	${NROFF} ${MANDOC} aliases.5 > aliases.0

mailq.0: mailq.1
	${NROFF} ${MANDOC} mailq.1 > mailq.0

newaliases.0: newaliases.1
	${NROFF} ${MANDOC} newaliases.1 > newaliases.0

sendmail.0: sendmail.8
	${NROFF} ${MANDOC} sendmail.8 > sendmail.0

install: install-sendmail install-docs

install-sendmail: sendmail
	${INSTALL} -o ${BINOWN} -g ${BINGRP} -m ${BINMODE} sendmail ${BINDIR}
	for i in ${LINKS}; do rm -f $$i; ln -s ${BINDIR}/sendmail $$i; done
	${INSTALL} -c -o ${BINOWN} -g ${BINGRP} -m 644 /dev/null \
	    ${STDIR}/sendmail.st
	${INSTALL} -c -o ${BINOWN} -g ${BINGRP} -m 444 sendmail.hf ${HFDIR}

# doesn't actually install them -- you may want to install pre-nroff versions
install-docs: aliases.0 mailq.0 newaliases.0 sendmail.0

clean:
	rm -f ${OBJS} sendmail aliases.0 mailq.0 newaliases.0 sendmail.0

# dependencies
#   gross overkill, and yet still not quite enough....
${OBJS}: sendmail.h conf.h

depend:
