/*
 * Copyright (c) 2000 Qualcomm Incorporated.  All rights reserved.
 * The file License.txt specifies the terms for use, modification,
 * and redistribution.
 *
 * Revisions:
 *     02/09/00  [rcg]
 *              - Added extended response codes.
 */

/*
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */


#include <sys/types.h>
#include <stdio.h>
#include <pwd.h>
#include <sys/stat.h>
#include <string.h>

#include <flock.h>

#include "config.h"

#ifndef HAVE_INDEX
#  define index(s, c)   strchr(s, c)
#endif /* HAVE_INDEX */

#if HAVE_STRINGS_H
#  include <strings.h>
#endif /* HAVE_STRINGS_H */

#if  HAVE_FCNTL_H
#  include <fcntl.h>
#endif /* HAVE_FCNTL_H */

#if HAVE_SYS_FILE_H
#  include <sys/file.h>
#endif /* HAVE_SYS_FILE_H */

#ifdef GDBM
#  include <gdbm.h>
#else
#  if HAVE_NDBM_H
#    include <ndbm.h>
#  endif /* HAVE_NDBM_H */
#endif /* GDBM */

#include "popper.h"

#ifdef   SCRAM
#  define  AUTHON
#  define  AUTHDB SCRAM
#else /* not SCRAM */
#  ifdef   APOP
#    define  AUTHON
#    define  AUTHDB APOP
#  endif /* APOP */
#endif /* SCRAM */


void 
downcase_uname ( POP *p, char *q );


/* 
 *  user:   Prompt for the user name at the start of a POP session
 */

int 
pop_user (p)
POP     * p;
{
    /* If there is an APOP or SCRAM database entry then don't allow a cleartext
       password over the net */
#ifdef AUTHON
#  ifdef GDBM
    char        authdb_file[BUFSIZ];
    GDBM_FILE   db;
#  else /* not GDBM */
    char        auth_dir[BUFSIZ];
    DBM        *db;
#  endif /* GDBM */
    int         fid;
    struct      passwd *pw;
    struct      stat st;
    datum       key, value;
    int         i;
#endif /* AUTHON */

    int         user_name_len;

    /* 
     * Downcase user name if requested 
     */
    if ( p->downcase_user )
        downcase_uname ( p, p->pop_parm[1] );
        
#ifdef KERBEROS
    if ( p->kerberos && strcmp(p->pop_parm[1], p->user) ) {
        pop_log ( p, POP_WARNING, HERE, 
                  "%s: auth failed: %s.%s@@%s vs %s",
                  p->client, kdata.pname, kdata.pinst, kdata.prealm, 
                  p->pop_parm[1] );
        return ( pop_msg ( p, POP_FAILURE, HERE,
                           "[AUTH] Wrong username supplied (%s vs. %s).", 
                           p->user, p->pop_parm[1] ) );
    }
#endif /* KERBEROS */

    /*
     * Save the user name 
     */
    user_name_len = strlen(p->pop_parm[1]);
    
    if ( !strcmp(p->pop_parm[1] + (user_name_len - 8), "-no-mime") ) {
        /* turn on mangling! */
        p->mangle_mime = 1;
        user_name_len -= 8;
        DEBUG_LOG4 ( p, "Turned on MIME mangling; "
                        "user name entered was (%d)'%.100s'; "
                        "user name reset to (%d)'%.100s'",
                     strlen(p->pop_parm[1]), p->pop_parm[1],
                     user_name_len,          p->pop_parm[1] );
      }
    
    if ( user_name_len > (sizeof(p->user) -1) ) {
        pop_log ( p, POP_WARNING, HERE, "Excessive user name length (%d); "
                                  "truncated to %d: %.100s",
                  user_name_len, (sizeof(p->user) -1), p->pop_parm[1] );
        user_name_len = sizeof(p->user) -1;
    }
    
    (void)strncpy(p->user, p->pop_parm[1], user_name_len);
    p->user[user_name_len] = 0;
    strcpy( p->authid, p->user );  /* userid is also authentication id */

#ifdef SCRAM_ONLY
    return ( pop_auth_fail ( p, POP_FAILURE, HERE, 
                             "[AUTH] You must use SCRAM-MD5 authentication "
                             "to connect to this server" ) );
#else /* not SCRAM_ONLY */
#  ifdef APOP_ONLY
    return ( pop_auth_fail ( p, POP_FAILURE, HERE, "[AUTH] You must use APOP "
                             "authentication to connect to this server" ) );
#  endif /* APOP_ONLY */
#endif /* SCRAM_ONLY */

#ifdef AUTHON

    /*
     * If this call fails then the database is not accessable (doesn't
     * exist?) in which case we can ignore an APOP user trying to
     * access Qpopper with a cleartext password.
     */

    if (((pw = getpwnam(p->user)) != NULL) &&
#ifdef GDBM
        ((db = gdbm_open(AUTHDB, 512, GDBM_READER, 0, 0)) != NULL))
#else
        ((db = dbm_open(AUTHDB, O_RDONLY, 0)) != NULL)) 
#endif
    {

#ifdef GDBM
        (void) strncpy(authdb_file, AUTHDB, sizeof(authdb_file) - 1);
        authdb_file[sizeof(authdb_file) - 1] = '\0';
#else
        (void) strncpy(auth_dir, AUTHDB, sizeof(auth_dir) - 5);
# if defined(BSD44_DBM)
        (void) strcat(auth_dir, ".db");
# else
        (void) strcat(auth_dir, ".dir");
# endif
#endif
#ifdef GDBM
        if ( stat (authdb_file, &st) != -1 && (st.st_mode & 0777) != 0600 ) 
#else
        if ( stat (auth_dir, &st)    != -1 && (st.st_mode & 0777) != 0600 ) 
#endif
        {
#ifdef GDBM
            gdbm_close (db);
#else
            dbm_close (db);
#endif
            return ( pop_auth_fail ( p, POP_FAILURE, HERE,
                                     "[SYS/PERM] POP authentication DB has wrong mode (0%o)",
                                     st.st_mode & 0777 ) );
        }
#ifdef GDBM
        fid = open(authdb_file, O_RDONLY);
#else
        fid = open(auth_dir, O_RDONLY);
#endif
        if(fid == -1) {
            int e = errno;
#ifdef GDBM
            gdbm_close (db);
#else
            dbm_close (db);
#endif
            return ( pop_auth_fail ( p, POP_FAILURE, HERE,
                                     "[SYS/TEMP] unable to lock POP authentication DB (%s)", 
                                     strerror(e) ) );
        }
        if (flock (fid, LOCK_SH) == -1) {
            int e = errno;
            (void) close(fid);
#ifdef GDBM
            gdbm_close (db);
#else
            dbm_close (db);
#endif 
            return ( pop_auth_fail ( p, POP_FAILURE, HERE,
                                     "[SYS/TEMP] unable to lock POP authentication DB (%s)", 
                                     strerror(e) ) );
        }
        key.dsize = strlen (key.dptr = p->user) + 1;
#ifdef GDBM
        value = gdbm_fetch (db, key);
        gdbm_close(db);
#else
        value = dbm_fetch (db, key);
        dbm_close (db);
#endif
        (void) close(fid);

        if ((value.dptr != NULL) &&
                (*value.dptr  != 0   ||
                ( value.dsize >= (i=strlen(value.dptr)+2)
                    && value.dptr[i]!= 0 )) ) {
            return ( pop_auth_fail ( p, POP_FAILURE, HERE,
                                     "[AUTH] You must use stronger authentication "
                                     "such as AUTH SCRAM-MD5 or APOP to connect "
                                     "to this server" ) );
        }
    }
#endif /* AUTHON */

    if ( p->AuthType == noauth )  /* If authentication method is unknown (i.e.  */
            p->AuthType = plain;  /*  not Kerberos) then assume plain text      */
    p->AuthState = user;          /* User command "succesful"                   */

    /*  Tell the user that the password is required */
    return ( pop_msg ( p, POP_SUCCESS, HERE,
                       "Password required for %s.",
                       p->user ) );
}


void downcase_uname ( POP *p, char *q )
{
    char * r;

    for (r = q; r && *r; r++)
        if (*r >= 'A' && *r <= 'Z')
            *r = ((*r) - 'A' + 'a');

    DEBUG_LOG1 ( p, "user name downcased to '%s'", q );
}
