/*
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */


/*
 * Copyright (c) 2000 Qualcomm Incorporated.  All rights reserved.
 * The file License.txt specifies the terms for use, modification,
 * and redistribution.
 *
 * Modifications:
 *
 *    03/07/00  [rcg]
 *              - Updated authentication OK message to account for hidden
 *                messages.
 */

#include <config.h>
#include <stdio.h>
#include <sys/types.h>
#include <string.h>

#if HAVE_STRINGS_H
#  include <strings.h>
#endif /* HAVE_STRINGS_H */

#include <pwd.h>
#include <netinet/in.h> /* For IPPORT_RESERVED */

#include "genpath.h"
#include "popper.h"

/*
 * Use /etc/hosts.equiv and the users .rhost file to validate the user.
 */
int pop_rpop (p)
     POP     *   p;
{
  struct passwd  *   pw;

    if (p->ipport >= IPPORT_RESERVED || p->ipport < IPPORT_RESERVED/2)  {
      pop_log(p,POP_PRIORITY, HERE,
              "RPOP command from %s (%s) on illegal port.",p->client,p->ipaddr);
        return (pop_msg(p,POP_FAILURE, HERE,
            "Permission denied.",p->user));
    }
    if (ruserok(p->client, 0, p->pop_parm[1], p->user) != 0)
        return (pop_msg(p,POP_FAILURE, HERE,
            "Permission denied.",p->user));
#ifdef NONAUTHFILE
    if (checknonauthfile(p->user) != 0)
        return (pop_msg(p,POP_FAILURE, HERE,
            "Permission denied.",p->user));
#endif
#ifdef AUTHFILE
    if (checkauthfile(p->user) != 0)
        return (pop_msg(p,POP_FAILURE, HERE,
            "Permission denied.",p->user));
#endif

    if ((pw = getpwnam(p->user)) == NULL)  /* "Can't happen" */
        return (pop_msg(p,POP_FAILURE, HERE,
            "Permission denied.",p->user));

    if (pw->pw_uid <= BLOCK_UID)
        return (pop_msg(p,POP_FAILURE, HERE, "Permission denied", p->user));

    /*  Build the name of the user's maildrop */
    if ( genpath ( p->user, 
                   p->drop_name, 
                   sizeof(p->drop_name), 
                   GNPH_SPOOL,
                   (p->debug ? p->trace : NULL),
                   p->debug )  < 0)
        return(pop_msg(p, POP_FAILURE, HERE, "Unable to create temporary drop name"));

    /*  Make a temporary copy of the user's maildrop */
    /*    and set the group and user id */
    if (pop_dropcopy(p, pw) != POP_SUCCESS) return (POP_FAILURE);

    /*  Get information about the maildrop */
    /* if (pop_dropinfo(p) != POP_SUCCESS) return(POP_FAILURE); */

    /*  Initialize the last-message-accessed number */
    p->last_msg = 0;

    p->AuthState = rpop;  /* plain or keberos authenticated successfully */
                          /* using Berk. r-files                         */

    /*  
     * Authorization completed successfully 
     */
    return ( pop_msg ( p, POP_SUCCESS, HERE,
                       "%s has %d visible message%s (%d hidden) in %d octets.",
                        p->user,
                        p->visible_msg_count == 1 ? "" : "s",
                        p->visible_msg_count, 
                        (p->msg_count - p->visible_msg_count),
                        p->drop_size ) );
}

