#include "config.h"

#include <sys/types.h>
#include <stdio.h>
#include <pwd.h>
#include <sys/stat.h>
#include <string.h>

#include <flock.h>

#ifndef HAVE_INDEX
#  define index(s, c)   strchr(s, c)
#endif /* HAVE_INDEX */

#if HAVE_STRINGS_H
#  include <strings.h>
#endif /* HAVE_STRINGS_H */

#if  HAVE_FCNTL_H
#  include <fcntl.h>
#endif /* HAVE_FCNTL_H */

#if HAVE_SYS_FILE_H
#  include <sys/file.h>
#endif /* HAVE_SYS_FILE_H */

#ifdef GDBM
#  include <gdbm.h>
#else
#  if HAVE_NDBM_H
#    include <ndbm.h>
#  endif /* HAVE_NDBM_H */
#endif /* GDBM */

#include "popper.h"


#ifdef GDBM
    typedef     qp_dbm     GDBM_FILE;
    typedef     QP_READER  GDBM_READER;
#else /* not GDBM */
    typedef     qp_dbm     DBM *;
    typedef     QP_READER  O_RDONLY;
#endif /* GDBM */


qp_dbm
qp_db_open ( const char *dbname, int sz, int md );

#ifdef GDBM
        ((db = gdbm_open(AUTHDB, 512, GDBM_READER, 0, 0)) != NULL))
#else
        ((db = dbm_open(AUTHDB, O_RDONLY, 0)) != NULL)) 
#endif
