/* 
 * Copyright (c) 2000 QUALCOMM Incorporated. All rights reserved.
 * The file License.txt specifies the terms for use, modification,
 * and redistribution.
 */
 
 
/*
 * Revisions:
 *
 * 04/21/00  [rg]
 *         - Now using Qvsnprintf et al.
 *         - Removed STDC_HEADERS/k&R junk.
 *
 * 01/27/00  [rg]
 *         - Replaced snprintf() with vsnprintf() for whiter whites
 *           and brighter colors.
 *
 * 01/25/00  [rg]
 *         - Replaced sprintf() with snprintf().
 *         - Log error message if buffer size exceeded.
 *         - Added filename and line number params; this info is now
 *           added to message.
 *
 * 12/22/99  [rg]
 *         - Changed __STDC__ to STDC_HEADERS, because sometimes
 *           __STDC__ is only defined if the compiler is invoked
 *           with flags which disable vendor extensions and force
 *           pure ANSI compliance; the intent of its use here is
 *           to check for modern compilers.
 *
 *  9/16/98  [py]
 *         - Edited to be independent of pop.
 *
 *  3/23/98  [PY]
 *         - Added the __STDC__ stuff.
 *
 */

#include "config.h"

#include <sys/types.h>
#include <errno.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>

#if HAVE_UNISTD_H
#  include <unistd.h>
#endif

#if HAVE_SYS_UNISTD_H
#  include <sys/unistd.h>
#endif

#if HAVE_STRINGS_H
#  include <strings.h>
#endif

#include <sys/stat.h>
#include <sys/file.h>

#include "popper.h"
#include "snprintf.h"


#  include <stdlib.h>
#  include <stdarg.h>



/*---------------------------------------------------
 *  logit:    Make a log entry
 *
 * Parameters:
 *    str:    FILE * for output, or NULL (to use syslog).
 *    stat:   The priority to use with syslog.
 *    fn:     File name whence called (__FILE__).
 *    ln:     Line number whence called (__LINE__).
 *    format: Format string.
 *    ...:    Optional parameters, as specified in format string.
 *
 * Returns:
 *    stat.
 */

static char msgbuf [ MAXLINELEN *2 ];

int
logit ( FILE        *str,       /* STREAM to write to, or NULL for syslog */
        log_level    stat,      /* log level */
        const char  *fn,        /* file name whence called */
        size_t       ln,        /* line number whence called */
        const char  *format,    /* format string to log */
        ... )                   /* parameters for format string */
{
    va_list     ap;

    char    *   date_time = NULL;
    time_t      clock;
    size_t      iLeft;
    int         iChunk;


    /* 
     * Get the information into msgbuf 
     */
    va_start ( ap, format );

    iLeft  = sizeof ( msgbuf ) -3; /* allow for CRLF NULL */
    iChunk = Qvsnprintf ( msgbuf, iLeft, format, ap );

    va_end ( ap );
    
    /*
     * Append file name and line number.
     */
    if ( DEBUGGING && fn != NULL ) {
        char whence [ 512 ];
        int  len;
        
        iLeft -= ( iChunk >= 0 ? iChunk : strlen(msgbuf) );
        len    = Qsprintf ( whence, " [%s:%d]", fn, ln );
        strncat ( msgbuf, whence, iLeft );
        iLeft -= len;
    }

    /* 
     * If the stream is given send output to it. otherwise to syslog. 
     */
    if ( str ) {
        clock = time(0);
        date_time = (char *)ctime(&clock);
        date_time [ strlen(date_time) - 1 ] = '\0';
        fprintf ( str, "%s [%d] %s\n", date_time, getpid(), msgbuf );
        fprintf ( str, "%s \n", date_time );
        fflush  ( str );
    }
    else {
        syslog ( stat, "%s", msgbuf) ;
    }
    
    if ( iChunk == -1 ) {
    /* 
     * We blew out the format buffer.
     */
        if ( str ) {
            fprintf ( str, "%s [%d] Buffer size exceeded logging msg: %s\n", 
                      date_time, getpid(), format );
            fprintf ( str, "%s \n", date_time );
            fflush  ( str );
        }
        else {
            syslog ( LOG_NOTICE, "Buffer size exceeded logging msg: %s", format );
        }
    } /* iChunk == -1 */

    return ( stat );
}
