#ifndef _EHLO_MASK_H_INCLUDED_
#define _EHLO_MASK_H_INCLUDED_

/*++
/* NAME
/*	name_mask 3h
/* SUMMARY
/*	map names to bit mask
/* SYNOPSIS
/*	#include <name_mask.h>
/* DESCRIPTION
/* .nf

 /*
  * Bit flags.
  */
#define EHLO_MASK_8BITMIME	(1<<0)	/* start of first byte */
#define EHLO_MASK_PIPELINING	(1<<1)
#define EHLO_MASK_SIZE		(1<<2)
#define EHLO_MASK_VRFY		(1<<3)
#define EHLO_MASK_ETRN		(1<<4)
#define EHLO_MASK_AUTH		(1<<5)
#define EHLO_MASK_VERP		(1<<6)
#define EHLO_MASK_STARTTLS	(1<<7)

#define EHLO_MASK_XCLIENT	(1<<8)	/* start of second byte */
#define EHLO_MASK_XFORWARD	(1<<9)
#define EHLO_MASK_ENHANCEDSTATUSCODES	(1<<10)
#define EHLO_MASK_DSN		(1<<11)
#define EHLO_MASK_SMTPUTF8	(1<<12)
#define EHLO_MASK_CHUNKING	(1<<13)
#define EHLO_MASK_REQUIRETLS	(1<<14)
#define EHLO_MASK_SILENT	(1<<15)	/* in-band signaling */

 /*
  * ESMTP verbs.
  */
#define EHLO_VERB_8BITMIME 	"8BITMIME"
#define EHLO_VERB_PIPELINING 	"PIPELINING"
#define EHLO_VERB_SIZE 		"SIZE"
#define EHLO_VERB_VRFY 		"VRFY"
#define EHLO_VERB_ETRN 		"ETRN"
#define EHLO_VERB_AUTH 		"AUTH"
#define EHLO_VERB_VERP 		"VERP"
#define EHLO_VERB_STARTTLS 	"STARTTLS"
#define EHLO_VERB_XCLIENT 	"XCLIENT"
#define EHLO_VERB_XFORWARD 	"XFORWARD"
#define EHLO_VERB_ENHANCEDSTATUSCODES 	"ENHANCEDSTATUSCODES"
#define EHLO_VERB_DSN 		"DSN"
#define EHLO_VERB_SMTPUTF8 	"SMTPUTF8"
#define EHLO_VERB_CHUNKING 	"CHUNKING"
#define EHLO_VERB_REQUIRETLS 	"REQUIRETLS"
#define EHLO_VERB_SILENT 	"SILENT-DISCARD"	/* in-band signaling */

 /*
  * Functions.
  */
extern int ehlo_mask(const char *);
extern const char *str_ehlo_mask(int);

/* LICENSE
/* .ad
/* .fi
/*	The Secure Mailer license must be distributed with this software.
/* AUTHOR(S)
/*	Wietse Venema
/*	IBM T.J. Watson Research
/*	P.O. Box 704
/*	Yorktown Heights, NY 10598, USA
/*
/*	Wietse Venema
/*	Google, Inc.
/*	111 8th Avenue
/*	New York, NY 10011, USA
/*--*/

#endif
