/*
CLASS:lsh_callback:
*/
#ifndef GABA_DEFINE
struct lsh_callback
{
  struct lsh_object super;
  void (*(f))(struct lsh_callback *self);
};
extern struct lsh_class lsh_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class lsh_callback_class =
{
  STATIC_HEADER,
  NULL,
  "lsh_callback",
  sizeof(struct lsh_callback),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:address_info:
*/
#ifndef GABA_DEFINE
struct address_info
{
  struct lsh_object super;
  struct lsh_string *ip;
  uint32_t port;
};
extern struct lsh_class address_info_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_address_info_free(struct lsh_object *o)
{
  struct address_info *i = (struct address_info *) o;
  lsh_string_free(i->ip);
}
struct lsh_class address_info_class =
{
  STATIC_HEADER,
  NULL,
  "address_info",
  sizeof(struct address_info),
  NULL,
  do_address_info_free,
};
#endif /* !GABA_DECLARE */

/*
CLASS:local_info:
*/
#ifndef GABA_DEFINE
struct local_info
{
  struct lsh_object super;
  struct lsh_string *directory;
  struct lsh_string *name;
};
extern struct lsh_class local_info_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_local_info_free(struct lsh_object *o)
{
  struct local_info *i = (struct local_info *) o;
  lsh_string_free(i->directory);
  lsh_string_free(i->name);
}
struct lsh_class local_info_class =
{
  STATIC_HEADER,
  NULL,
  "local_info",
  sizeof(struct local_info),
  NULL,
  do_local_info_free,
};
#endif /* !GABA_DECLARE */

/*
CLASS:listen_value:
*/
#ifndef GABA_DEFINE
struct listen_value
{
  struct lsh_object super;
  int fd;
  struct address_info *peer;
};
extern struct lsh_class listen_value_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_listen_value_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct listen_value *i = (struct listen_value *) o;
  mark((struct lsh_object *) i->peer);
}
struct lsh_class listen_value_class =
{
  STATIC_HEADER,
  NULL,
  "listen_value",
  sizeof(struct listen_value),
  do_listen_value_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:io_connect_state:resource
*/
#ifndef GABA_DEFINE
struct io_connect_state
{
  struct resource super;
  int fd;
  void (*(done))(struct io_connect_state *self,int fd);
  void (*(error))(struct io_connect_state *self,int err);
};
extern struct lsh_class io_connect_state_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class io_connect_state_class =
{
  STATIC_HEADER,
  &(resource_class),
  "io_connect_state",
  sizeof(struct io_connect_state),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

