/*
CLASS:lsh_signal_handler:resource
*/
#ifndef GABA_DEFINE
struct lsh_signal_handler
{
  struct resource super;
  int signum;
  struct lsh_callback *action;
};
extern struct lsh_class lsh_signal_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_lsh_signal_handler_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct lsh_signal_handler *i = (struct lsh_signal_handler *) o;
  mark((struct lsh_object *) i->action);
}
struct lsh_class lsh_signal_handler_class =
{
  STATIC_HEADER,
  &(resource_class),
  "lsh_signal_handler",
  sizeof(struct lsh_signal_handler),
  do_lsh_signal_handler_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:lsh_callout:resource
*/
#ifndef GABA_DEFINE
struct lsh_callout
{
  struct resource super;
  struct timeval when;
  struct lsh_callback *action;
};
extern struct lsh_class lsh_callout_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_lsh_callout_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct lsh_callout *i = (struct lsh_callout *) o;
  mark((struct lsh_object *) i->action);
}
struct lsh_class lsh_callout_class =
{
  STATIC_HEADER,
  &(resource_class),
  "lsh_callout",
  sizeof(struct lsh_callout),
  do_lsh_callout_mark,
  NULL,
};
#endif /* !GABA_DECLARE */

