/*
CLASS:ssh_connection:resource
*/
#ifndef GABA_DEFINE
struct ssh_connection
{
  struct resource super;
  void (*(write))(struct ssh_connection *self,struct lsh_string *);
  void (*(disconnect))(struct ssh_connection *self,uint32_t reason,const char *msg);
  struct resource_list *resources;
  struct ssh_channel *(*(channels));
  struct alist *global_requests;
  struct alist *channel_types;
  enum channel_alloc_state (*(alloc_state));
  uint32_t allocated_channels;
  uint32_t used_channels;
  uint32_t next_channel;
  uint32_t channel_count;
  uint32_t max_channels;
  struct object_queue forwarded_ports;
  struct client_x11_display *x11_display;
  struct object_queue active_global_requests;
  struct object_queue pending_global_requests;
  int pending_close;
};
extern struct lsh_class ssh_connection_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_ssh_connection_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct ssh_connection *i = (struct ssh_connection *) o;
  mark((struct lsh_object *) i->resources);
  {
    unsigned k1;
    for(k1=0; k1<i->used_channels; k1++)
      mark((struct lsh_object *) (i->channels)[k1]);
  };
  mark((struct lsh_object *) i->global_requests);
  mark((struct lsh_object *) i->channel_types);
  object_queue_mark(&(i->forwarded_ports),
    mark);
  mark((struct lsh_object *) i->x11_display);
  object_queue_mark(&(i->active_global_requests),
    mark);
  object_queue_mark(&(i->pending_global_requests),
    mark);
}
static void
do_ssh_connection_free(struct lsh_object *o)
{
  struct ssh_connection *i = (struct ssh_connection *) o;
  lsh_space_free(i->channels);
  lsh_space_free(i->alloc_state);
  object_queue_free(&(i->forwarded_ports));
  object_queue_free(&(i->active_global_requests));
  object_queue_free(&(i->pending_global_requests));
}
struct lsh_class ssh_connection_class =
{
  STATIC_HEADER,
  &(resource_class),
  "ssh_connection",
  sizeof(struct ssh_connection),
  do_ssh_connection_mark,
  do_ssh_connection_free,
};
#endif /* !GABA_DECLARE */

/*
CLASS:global_request:
*/
#ifndef GABA_DEFINE
struct global_request
{
  struct lsh_object super;
  void (*(handler))(struct global_request *self,struct ssh_connection *table,uint32_t type,int want_reply,struct simple_buffer *args,struct command_continuation *c,struct exception_handler *e);
};
extern struct lsh_class global_request_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class global_request_class =
{
  STATIC_HEADER,
  NULL,
  "global_request",
  sizeof(struct global_request),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

/*
CLASS:channel_open:
*/
#ifndef GABA_DEFINE
struct channel_open
{
  struct lsh_object super;
  void (*(handler))(struct channel_open *self,struct ssh_connection *connection,struct channel_open_info *info,struct simple_buffer *data,struct command_continuation *c,struct exception_handler *e);
};
extern struct lsh_class channel_open_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class channel_open_class =
{
  STATIC_HEADER,
  NULL,
  "channel_open",
  sizeof(struct channel_open),
  NULL,
  NULL,
};
#endif /* !GABA_DECLARE */

